/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC;

import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC.TimeoutDC;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterMockWithNS {
    protected static ORB orb;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Properties props = Initializer.loadProperties(args);
        PropertyConfigurator.configure((Properties)props);
        String name = "Timeout";
        String dns = "edu/sc/seis";
        String corbaLoc = props.getProperty("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc");
        if (name == null || dns == null || corbaLoc == null) {
            System.out.println("Unable to load name, dns or corbaloc!");
            System.exit(1);
        }
        try {
            orb = (ORB)org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            new AllVTFactory().register(orb);
            FissuresNamingService fisName = new FissuresNamingService(orb);
            fisName.setNameServiceCorbaLoc(corbaLoc);
            DataCenter pl = new TimeoutDC()._this((org.omg.CORBA.ORB)orb);
            fisName.rebind(dns, name, (Object)pl);
            logger.info("Bound to Name Service");
            POA rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            logger.info("Running the ORB");
            POAManager manager = rootPOA.the_POAManager();
            manager.activate();
            orb.run();
        }
        catch (NotFound e) {
            logger.error("Couldn!t bind to the naming service", (Throwable)e);
        }
        catch (AdapterInactive e) {
            logger.error("POA problem.", (Throwable)e);
        }
        catch (InvalidName e) {
            logger.error("Naming problem.", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("Couldn't... ", e);
        }
        finally {
            try {
                if (orb != null) {
                    FissuresNamingService fisName = new FissuresNamingService(orb);
                    fisName.unbind(dns, "DataCenter", name);
                }
            }
            catch (Exception e) {}
        }
        logger.info("MockDC done.");
    }

    static {
        logger = LoggerFactory.getLogger(RegisterMockWithNS.class);
    }
}

