/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.proj.Projection;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.fissuresUtil.map.layers.OverriddenOMLayer;
import java.awt.Graphics;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FissuresShapeLayer
extends ShapeLayer
implements OverriddenOMLayer {
    private int overviewLineWidth = 1;
    private int lineWidthThreshold = 5500000;
    private boolean overrideProjectionChanged = false;
    private static Logger logger = LoggerFactory.getLogger(FissuresShapeLayer.class);

    public void renderDataForProjection(Projection p, Graphics g) {
        logger.debug(ExceptionReporterUtils.getMemoryUsage() + " InformativeShapeLayer: rendering shape layer");
        super.renderDataForProjection(p, g);
    }

    @Override
    public void setOverrideProjectionChanged(boolean override) {
        this.overrideProjectionChanged = override;
    }

    public void projectionChanged(ProjectionEvent e) {
        if (this.overrideProjectionChanged) {
            this.doPrepare();
            this.repaint();
        } else {
            super.projectionChanged(e);
        }
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.overviewLineWidth = props.containsKey("overviewLineWidth") ? Integer.parseInt((String)props.get("overviewLineWidth")) : 1;
        this.lineWidthThreshold = props.containsKey("lineWidthThreshold") ? Integer.parseInt((String)props.get("lineWidthThreshold")) : 5500000;
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        props.put("overviewLineWidth", "" + this.overviewLineWidth);
        props.put("lineWidthThreshold", "" + this.lineWidthThreshold);
        return props;
    }
}

