/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.BoxArea;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.PointDistanceAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.bag.AreaUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.flow.querier.EventFinderQuery;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDB
extends AbstractHibernateDB {
    protected String getLastEventString;
    protected String finderQueryBase;
    protected String finderQueryAvoidDateline;
    protected String finderQueryAroundDateline;
    protected String getIdenticalEventString;
    protected String eventByTimeAndDepth;
    protected String eventByName;
    private static EventDB singleton;
    public static final float INCONCEIVABLY_SMALL_MAGNITUDE = -99.0f;
    public static final float INCONCEIVABLY_LARGE_MAGNITUDE = 12.0f;
    public static final float INCONCEIVABLY_SMALL_DEPTH = -99.0f;
    public static final float INCONCEIVABLY_LARGE_DEPTH = 7000.0f;
    private static final Logger logger;

    protected EventDB() {
        this.initQueryStrings();
    }

    protected void initQueryStrings() {
        this.getLastEventString = "From " + this.getEventClass().getName() + " e ORDER BY e.id desc";
        this.finderQueryBase = "select distinct e FROM " + this.getEventClass().getName() + " e inner join e.preferred.magnitudeList m WHERE e.preferred.location.latitude between :minLat AND :maxLat AND m.value between :minMag AND :maxMag  AND e.preferred.originTime.time between :minTime AND :maxTime  AND e.preferred.location.depth.value between :minDepth and :maxDepth  ";
        this.finderQueryAvoidDateline = this.finderQueryBase + "AND e.preferred.location.longitude between :minLon and :maxLon ";
        this.finderQueryAroundDateline = this.finderQueryBase + " AND ((:minLon <= e.preferred.location.longitude) OR (e.preferred.location.longitude <= :maxLon))";
        this.getIdenticalEventString = "From " + this.getEventClass().getName() + " e WHERE e.preferred.originTime.time = :originTime AND e.preferred.location.latitude = :lat AND e.preferred.location.longitude = :lon AND e.preferred.location.depth.value = :depth AND e.preferred.catalog = :catalog AND e.preferred._id = :originid ";
        this.eventByTimeAndDepth = "From " + this.getEventClass().getName() + " e WHERE e.preferred.originTime.time between :minTime and :maxTime AND e.preferred.location.depth.value between :minDepth and :maxDepth";
        this.eventByName = "From " + this.getEventClass().getName() + " e WHERE e.attr.name = :name";
    }

    public List<CacheEvent> getAll() {
        return EventDB.getSession().createQuery("from " + this.getEventClass().getName()).list();
    }

    public CacheEvent[] getByName(String name) {
        Query query = EventDB.getSession().createQuery(this.eventByName);
        query.setString("name", name);
        List result = query.list();
        CacheEvent[] out = result.toArray(new CacheEvent[0]);
        return out;
    }

    public List<CacheEvent> query(EventFinderQuery q) {
        BoxArea ba = AreaUtil.makeContainingBox(q.getArea());
        String queryString = ba.min_longitude <= ba.max_longitude ? this.finderQueryAvoidDateline : this.finderQueryAroundDateline;
        Session session = EventDB.getSession();
        Query query = session.createQuery(queryString);
        query.setFloat("minLat", ba.min_latitude);
        query.setFloat("maxLat", ba.max_latitude);
        query.setFloat("minMag", q.getMinMag());
        query.setFloat("maxMag", q.getMaxMag());
        query.setTimestamp("minTime", (Date)q.getTime().getBeginTime().getTimestamp());
        query.setTimestamp("maxTime", (Date)q.getTime().getEndTime().getTimestamp());
        query.setDouble("minDepth", q.getMinDepth());
        query.setDouble("maxDepth", q.getMaxDepth());
        query.setFloat("minLon", ba.min_longitude);
        query.setFloat("maxLon", ba.max_longitude);
        return query.list();
    }

    public CacheEvent getEvent(int dbid) throws NotFound {
        Session session = EventDB.getSession();
        CacheEvent out = (CacheEvent)session.get(this.getEventClass(), (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public long put(CacheEvent event) {
        Session session = EventDB.getSession();
        this.internUnit(event);
        Integer dbid = (Integer)session.save((Object)event);
        return dbid.longValue();
    }

    public void delete(CacheEvent event) {
        EventDB.getSession().delete((Object)event);
    }

    public CacheEvent getLastEvent() throws NotFound {
        Session session = EventDB.getSession();
        Query query = session.createQuery(this.getLastEventString);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            CacheEvent out = (CacheEvent)result.get(0);
            return out;
        }
        throw new NotFound();
    }

    public CacheEvent getIdenticalEvent(CacheEvent e) {
        Session session = EventDB.getSession();
        Query query = session.createQuery(this.getIdenticalEventString);
        query.setMaxResults(1);
        try {
            query.setString("catalog", e.get_preferred_origin().getCatalog());
            query.setString("originid", e.get_preferred_origin().get_id());
            query.setTimestamp("originTime", (Date)new MicroSecondDate(e.get_preferred_origin().getOriginTime()).getTimestamp());
            query.setDouble("depth", e.get_preferred_origin().getLocation().depth.value);
            query.setDouble("lat", (double)e.get_preferred_origin().getLocation().latitude);
            query.setDouble("lon", (double)e.get_preferred_origin().getLocation().longitude);
            List result = query.list();
            if (result.size() > 0) {
                CacheEvent out = (CacheEvent)result.get(0);
                return out;
            }
        }
        catch (NoPreferredOrigin noPreferredOrigin) {
            // empty catch block
        }
        return null;
    }

    public String[] getCatalogs() {
        Query q = EventDB.getSession().createQuery("select distinct catalog from " + OriginImpl.class.getName());
        List out = q.list();
        return out.toArray(new String[0]);
    }

    public String[] getContributors() {
        Query q = EventDB.getSession().createQuery("select distinct contributor from " + OriginImpl.class.getName());
        List out = q.list();
        return out.toArray(new String[0]);
    }

    public String[] getCatalogsFor(String contributor) {
        Query q = EventDB.getSession().createQuery("select distinct catalog from " + OriginImpl.class.getName() + " where contributor = :contributor");
        q.setString("contributor", contributor);
        List out = q.list();
        return out.toArray(new String[0]);
    }

    public List<CacheEvent> getSimilarEvents(CacheEvent event, TimeInterval timeTolerance, QuantityImpl positionTolerance) throws NotFound {
        EventFinderQuery query = new EventFinderQuery();
        OriginImpl origin = EventUtil.extractOrigin((EventAccessOperations)event);
        MicroSecondDate evTime = new MicroSecondDate(origin.getOriginTime());
        MicroSecondTimeRange timeRange = new MicroSecondTimeRange(evTime.subtract(timeTolerance), evTime.add(timeTolerance));
        PointDistanceAreaImpl area = new PointDistanceAreaImpl(origin.getLocation().latitude, origin.getLocation().longitude, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.DEGREE), (Quantity)positionTolerance);
        query.setTime(timeRange);
        query.setArea((Area)area);
        query.setMinMag(-99.0f);
        query.setMaxMag(12.0f);
        query.setMinDepth(-99.0);
        query.setMaxDepth(7000.0);
        return this.query(query);
    }

    public CacheEvent[] getEventsByTimeAndDepthRanges(MicroSecondDate minTime, MicroSecondDate maxTime, double minDepth, double maxDepth) {
        Session session = EventDB.getSession();
        Query query = session.createQuery(this.eventByTimeAndDepth);
        query.setTimestamp("minTime", (Date)minTime.getTimestamp());
        query.setTimestamp("maxTime", (Date)maxTime.getTimestamp());
        query.setDouble("minDepth", minDepth);
        query.setDouble("maxDepth", maxDepth);
        List result = query.list();
        CacheEvent[] out = result.toArray(new CacheEvent[0]);
        return out;
    }

    public static EventDB getSingleton() {
        if (singleton == null) {
            singleton = new EventDB();
        }
        return singleton;
    }

    protected Class getEventClass() {
        return CacheEvent.class;
    }

    protected void internUnit(CacheEvent event) {
        EventDB.internUnit(event.getOrigin().getLocation());
        Origin[] origins = event.get_origins();
        for (int i = 0; i < origins.length; ++i) {
            EventDB.internUnit(origins[i].getLocation());
        }
    }

    static {
        logger = LoggerFactory.getLogger(EventDB.class);
    }
}

