/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.MovableDrawable;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class Crosshair
implements MovableDrawable {
    private int x;
    private int y;
    private Polygon leftYTriangle;
    private Polygon topXTriangle;
    private Color color = Color.BLACK;
    private boolean visible = true;
    private boolean bottomTriangleVisible = false;
    private boolean topTriangleVisible = false;

    public Crosshair(int x, int y) {
        int[] xTriX = new int[]{x - 5, x, x + 5, x + 5, x - 5};
        int[] xTriY = new int[]{6, 1, 6, 12, 12};
        this.topXTriangle = new Polygon(xTriX, xTriY, 5);
        int[] yTriX = new int[]{6, 1, 6, 12, 12};
        int[] yTriY = new int[]{y - 5, y, y + 5, y + 5, y - 5};
        this.leftYTriangle = new Polygon(yTriX, yTriY, 5);
        this.x = x;
        this.y = y;
    }

    @Override
    public void setXY(int x, int y) {
        this.topXTriangle.translate(x - this.x, 0);
        this.leftYTriangle.translate(0, y - this.y);
        this.x = x;
        this.y = y;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public void setVisibility(boolean b) {
        this.visible = b;
    }

    @Override
    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        if (this.visible && !SeismogramDisplay.PRINTING) {
            canvas.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
            canvas.setPaint(Color.RED);
            if (this.topTriangleVisible) {
                canvas.draw(this.topXTriangle);
            }
            canvas.draw(this.leftYTriangle);
            if (this.bottomTriangleVisible) {
                int[] bottomXTriX = new int[]{this.x - 5, this.x, this.x + 5, this.x + 5, this.x - 5};
                int[] bottomXTriY = new int[]{size.height - 6, size.height - 1, size.height - 6, size.height - 12, size.height - 12};
                canvas.draw(new Polygon(bottomXTriX, bottomXTriY, 5));
            }
        }
    }

    public void setBottomTriangleVisible(boolean visible) {
        this.bottomTriangleVisible = visible;
    }

    public void setTopTriangleVisible(boolean visible) {
        this.topTriangleVisible = visible;
    }
}

