/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigDefinitions {
    private static final Logger logger = LoggerFactory.getLogger(ConfigDefinitions.class);
    private Map idsToConfigs = new HashMap();

    public boolean referencesDefinition(Element el) {
        return el.hasAttribute("base");
    }

    public static String definitionName(Element el) {
        return el.getAttribute("base");
    }

    public boolean hasDefinition(Element el) {
        return this.idsToConfigs.containsKey(ConfigDefinitions.definitionName(el));
    }

    public Object getDefinition(Element el) {
        if (!this.hasDefinition(el)) {
            String elementPath = el.getTagName();
            for (Node parent = el.getParentNode(); parent != null && parent instanceof Element; parent = parent.getParentNode()) {
                elementPath = ((Element)parent).getTagName() + "/" + elementPath;
            }
            throw new RuntimeException(elementPath + " references an undefined definition " + ConfigDefinitions.definitionName(el));
        }
        return this.idsToConfigs.get(el.getAttribute("base"));
    }

    public void updateDefinitions(Element el, Object o) {
        if (el.hasAttribute("id")) {
            String id = el.getAttribute("id");
            if (this.idsToConfigs.containsKey(id)) {
                logger.debug("Overwriting " + this.idsToConfigs.get(id) + " with " + o + " on id " + id);
            }
            this.idsToConfigs.put(id, o);
        } else if (el.hasAttribute("overwritingId")) {
            this.idsToConfigs.put(el.getAttribute("overwritingId"), o);
        }
    }
}

