/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.configuration.ColorConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ColorClassConfiguration {
    private Class colorClass;
    private static ConfigDefinitions defs = new ConfigDefinitions();
    private Color[] colors = new Color[]{Color.BLACK};

    public ColorClassConfiguration(Element el) {
        if (defs.referencesDefinition(el)) {
            ColorClassConfiguration definer = (ColorClassConfiguration)defs.getDefinition(el);
            this.colorClass = definer.colorClass;
            this.colors = definer.colors;
        } else {
            Color[] configColors = ColorClassConfiguration.extractColors(el);
            if (configColors.length > 0) {
                this.colors = configColors;
            }
            if (el.getTagName().equals("flagColors")) {
                this.colorClass = Flag.class;
            } else if (el.getTagName().equals("traceColors")) {
                this.colorClass = DrawableSeismogram.class;
            }
            defs.updateDefinitions(el, this);
        }
    }

    public static Color[] extractColors(Element el) {
        NodeList colorNodes = DOMHelper.extractNodes(el, "color");
        Color[] colors = new Color[colorNodes.getLength()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ColorConfiguration.create((Element)colorNodes.item(i)).createColor();
        }
        return colors;
    }

    public Class getColorClass() {
        return this.colorClass;
    }

    public Color[] getColors() {
        return this.colors;
    }
}

