/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.ScaleMapper;
import java.util.Date;

public abstract class TimeScaleMapper
implements ScaleMapper {
    protected int totalPixels;
    protected MicroSecondDate minTick;
    protected MicroSecondDate beginTime;
    protected MicroSecondDate endTime;
    protected int firstMajorTick = 0;
    protected int majorTickStep = 50;
    protected double tickInc;
    protected int numTicks = 0;
    protected int hintPixels;

    public TimeScaleMapper(int totalPixels, int hintPixels, MicroSecondDate beginTime, MicroSecondDate endTime) {
        if (endTime.before((Date)beginTime)) {
            throw new IllegalArgumentException("endTime must be after beginTime, " + beginTime.toString() + "  " + endTime.toString());
        }
        this.totalPixels = totalPixels;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public TimeScaleMapper(int totalPixels, MicroSecondDate beginTime, MicroSecondDate endTime) {
        if (endTime.before((Date)beginTime)) {
            throw new IllegalArgumentException("endTime must be after beginTime, " + beginTime.toString() + "  " + endTime.toString());
        }
        this.totalPixels = totalPixels;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public void setTotalPixels(int totalPixels) {
        this.totalPixels = totalPixels;
        this.calculateTicks();
    }

    public void setTotalPixels(int totalPixels, int hintPixels) {
        this.hintPixels = hintPixels;
        this.totalPixels = totalPixels;
        this.calculateTicks();
    }

    public void setHintPixels(int hintPixels) {
        this.hintPixels = hintPixels;
        this.calculateTicks();
    }

    public void setTimes(MicroSecondDate beginTime, MicroSecondDate endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.calculateTicks();
    }

    @Override
    public boolean isMajorTick(int i) {
        return i % this.majorTickStep == this.firstMajorTick;
    }

    public boolean isLabelTick(int i) {
        return i % (2 * this.majorTickStep) == this.firstMajorTick;
    }

    @Override
    public String getAxisLabel() {
        return "Time";
    }

    protected abstract void calculateTicks();
}

