/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.bag.Statistics;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeismogramIterator
implements Iterator {
    private Map statisticsMap = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(SeismogramIterator.class);
    private List iterateList = new ArrayList();
    private Map points = new HashMap();
    private int currentPoint;
    private int numPoints;
    private int endPoint;
    private LocalSeismogramImpl[] seismograms;
    private MicroSecondTimeRange timeRange;
    private MicroSecondTimeRange seisTimeRange;
    private String name;
    private SamplingImpl sampling;
    private UnitImpl unit;
    public static final QuantityImpl NOT_A_NUMBER = new QuantityImpl(Double.NaN, (Unit)UnitImpl.COUNT);

    public SeismogramIterator(String name, LocalSeismogramImpl[] seismograms) {
        this(name, seismograms, RangeTool.getFullTime(seismograms));
    }

    public SeismogramIterator(String name, LocalSeismogramImpl[] seismograms, MicroSecondTimeRange timeRange) {
        this.name = name;
        if (seismograms.length > 0) {
            seismograms = ReduceTool.removeContained(seismograms);
            this.seismograms = SortTool.byBeginTimeAscending(seismograms);
            LocalSeismogramImpl[] seis = this.seismograms;
            MicroSecondDate startTime = seis[0].getBeginTime();
            MicroSecondDate endTime = seis[seis.length - 1].getEndTime();
            TimeInterval samplingInterval = seis[0].getSampling().getPeriod();
            this.sampling = seis[0].getSampling();
            this.unit = seis[0].getUnit();
            this.seisTimeRange = new MicroSecondTimeRange(startTime, endTime);
            this.addToIterateList(seis[0], 0, seis[0].getNumPoints());
            for (int i = 1; i < seis.length; ++i) {
                LocalSeismogramImpl prev = seis[i - 1];
                LocalSeismogramImpl current = seis[i];
                if (RangeTool.areOverlapping(prev, current)) {
                    MicroSecondDate currentStartTime = prev.getEndTime().add(samplingInterval);
                    MicroSecondDate currentEndTime = current.getEndTime();
                    MicroSecondTimeRange currentTR = new MicroSecondTimeRange(currentStartTime, currentEndTime);
                    int[] points = DisplayUtils.getSeisPoints(current, currentTR);
                    this.addToIterateList(current, points[0], current.getNumPoints());
                    continue;
                }
                if (RangeTool.areContiguous(prev, current)) {
                    this.addToIterateList(current, 0, current.getNumPoints());
                    continue;
                }
                TimeInterval difference = current.getBeginTime().difference(prev.getEndTime());
                TimeInterval convSampling = (TimeInterval)samplingInterval.convertTo(UnitImpl.MICROSECOND);
                double gapPoints = difference.divideBy((QuantityImpl)convSampling).getValue();
                this.addToIterateList(new Gap((int)gapPoints), 0, (int)gapPoints);
                this.addToIterateList(current, 0, current.getNumPoints());
            }
            this.setTimeRange(timeRange);
        } else {
            this.seismograms = seismograms;
            this.timeRange = DisplayUtils.ZERO_TIME;
            this.seisTimeRange = DisplayUtils.ZERO_TIME;
        }
    }

    public QuantityImpl getValueAt(int position) {
        try {
            Object[] seisAndPoint = this.getSeisAtWithInternal(position);
            if (seisAndPoint[0] == null) {
                return null;
            }
            LocalSeismogramImpl seis = (LocalSeismogramImpl)seisAndPoint[0];
            Integer point = (Integer)seisAndPoint[1];
            return seis.getValueAt(point.intValue());
        }
        catch (CodecException e) {
            GlobalExceptionHandler.handle(e);
            return null;
        }
    }

    public Object next() {
        if (this.currentPoint < this.endPoint) {
            return this.getValueAt(this.currentPoint++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.currentPoint < this.endPoint;
    }

    @Override
    public void remove() {
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public int numPointsLeft() {
        return this.endPoint - this.currentPoint;
    }

    public int getStartPoint() {
        return this.currentPoint;
    }

    public MicroSecondTimeRange getTimeRange() {
        return this.timeRange;
    }

    public MicroSecondTimeRange getSeisTime() {
        return this.seisTimeRange;
    }

    public void setTimeRange(MicroSecondTimeRange timeRange) {
        this.timeRange = timeRange;
        if (timeRange == DisplayUtils.ZERO_TIME) {
            this.currentPoint = this.numPoints;
        } else if (this.seisTimeRange == DisplayUtils.ZERO_TIME) {
            this.currentPoint = this.numPoints;
        } else {
            long seisBegin = this.seisTimeRange.getBeginTime().getMicroSecondTime();
            long seisEnd = this.seisTimeRange.getEndTime().getMicroSecondTime();
            long timeBegin = timeRange.getBeginTime().getMicroSecondTime();
            long timeEnd = timeRange.getEndTime().getMicroSecondTime();
            this.currentPoint = (int)DisplayUtils.linearInterp(seisBegin, seisEnd, this.numPoints, timeBegin);
            this.endPoint = (int)DisplayUtils.linearInterp(seisBegin, seisEnd, this.numPoints, timeEnd);
            if (this.currentPoint < 0) {
                this.currentPoint = 0;
            }
            if (this.endPoint > this.numPoints) {
                this.endPoint = this.numPoints;
            }
        }
    }

    public LocalSeismogramImpl[] getSeismograms() {
        return this.seismograms;
    }

    public double[] minMaxMean() {
        return this.minMaxMean(this.currentPoint, this.endPoint);
    }

    public double[] minMaxMean(int startPoint, int endPoint) {
        if (startPoint >= endPoint) {
            double[] zeros = new double[]{Double.NaN, Double.NaN, Double.NaN};
            return zeros;
        }
        int currentPoint = startPoint;
        double[] minMaxMean = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0};
        int totalNumCalculated = 0;
        if (currentPoint < this.numPoints && endPoint > 0) {
            Object[] array;
            LocalSeismogramImpl curSeis;
            double meanStore = 0.0;
            while (currentPoint < endPoint && (curSeis = (LocalSeismogramImpl)(array = this.getSeisAtWithInternal(currentPoint))[0]) != null) {
                if (curSeis != null && !(curSeis instanceof Gap)) {
                    double[] curMinMaxMean;
                    int lastPoint;
                    int internalStartPoint = (Integer)array[1];
                    int shift = 0;
                    if (internalStartPoint < 0) {
                        shift = Math.abs(internalStartPoint);
                        internalStartPoint = 0;
                    }
                    if ((lastPoint = ((int[])this.points.get(curSeis))[1]) - internalStartPoint + currentPoint + shift >= endPoint) {
                        lastPoint = internalStartPoint + (endPoint - (currentPoint + shift));
                    }
                    if ((curMinMaxMean = this.getStatistics(curSeis).minMaxMean(internalStartPoint, lastPoint))[0] < minMaxMean[0]) {
                        minMaxMean[0] = curMinMaxMean[0];
                    }
                    if (curMinMaxMean[1] > minMaxMean[1]) {
                        minMaxMean[1] = curMinMaxMean[1];
                    }
                    int curNumCalculated = lastPoint - internalStartPoint;
                    meanStore += curMinMaxMean[2] * (double)curNumCalculated;
                    totalNumCalculated += curNumCalculated;
                    currentPoint += curNumCalculated + shift;
                } else if (curSeis instanceof Gap) {
                    currentPoint += ((Gap)curSeis).getNumPoints() - (Integer)array[1];
                }
                minMaxMean[2] = meanStore / (double)totalNumCalculated;
            }
        }
        return minMaxMean;
    }

    public boolean equals(Object other) {
        LocalSeismogramImpl[] otherSeismograms;
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SeismogramIterator otherIterator = (SeismogramIterator)other;
        if (this.timeRange.equals(otherIterator.getTimeRange()) && (otherSeismograms = otherIterator.getSeismograms()).length == this.seismograms.length) {
            for (int i = 0; i < this.seismograms.length; ++i) {
                if (this.seismograms[i].get_id().equals(otherSeismograms[i].get_id())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 52;
        result = 37 * result + this.timeRange.hashCode();
        for (int i = 0; i < this.seismograms.length; ++i) {
            result = 37 * result + this.seismograms[i].get_id().hashCode();
        }
        return result;
    }

    public String toString() {
        return this.name + " iterator";
    }

    private Object[] getSeisAtWithInternal(int position) {
        Iterator it = this.iterateList.iterator();
        int curPosition = 0;
        while (it.hasNext()) {
            Object current = it.next();
            int[] curPoints = (int[])this.points.get(current);
            if (curPoints[1] - curPoints[0] + curPosition > position) {
                Object[] seisWithInternal = new Object[]{current, new Integer(position - curPosition)};
                return seisWithInternal;
            }
            curPosition += curPoints[1] - curPoints[0];
        }
        return new Object[2];
    }

    private void addToIterateList(LocalSeismogramImpl toBeAdded, int firstPoint, int lastPoint) {
        this.iterateList.add(toBeAdded);
        if (firstPoint < 0) {
            firstPoint = 0;
        }
        if (lastPoint > toBeAdded.getNumPoints()) {
            lastPoint = toBeAdded.getNumPoints();
        }
        int[] addPoints = new int[]{firstPoint, lastPoint};
        this.points.put(toBeAdded, addPoints);
        this.numPoints += lastPoint - firstPoint;
    }

    public SamplingImpl getSampling() {
        return this.sampling;
    }

    private Statistics getStatistics(LocalSeismogramImpl seis) {
        Statistics stat = (Statistics)this.statisticsMap.get(seis);
        if (stat == null) {
            try {
                stat = new Statistics(seis);
                this.statisticsMap.put(seis, stat);
            }
            catch (FissuresException e) {
                throw new RuntimeException("Should never happen becuase this only gets thrown for bad data and SeismogramCOntainer should check for that.", e);
            }
        }
        return stat;
    }

    public UnitImpl getUnit() {
        return this.unit;
    }

    private class Gap
    extends LocalSeismogramImpl {
        private int length;

        private Gap(int length) {
            this.length = length;
        }

        public QuantityImpl getValueAt(int position) {
            return NOT_A_NUMBER;
        }

        public int getNumPoints() {
            return this.length;
        }
    }
}

