/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.util;

import edu.sc.seis.fissuresUtil.database.WrappedSQLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLoader {
    private Properties sqlProps = new Properties();
    private static final String propsLoc = "edu/sc/seis/fissuresUtil/database/util/SQLLoader.prop";
    public static final String VELOCITY_LOGGER_NAME = "runtime.log.logsystem.log4j.logger";
    private static final Logger logger = LoggerFactory.getLogger(SQLLoader.class);
    private Context context;
    private static VelocityEngine ve;

    public SQLLoader(String template) throws SQLException {
        this(template, (Context)new VelocityContext());
    }

    public SQLLoader(String template, Context ctx) throws SQLException {
        try {
            this.context = ctx;
            StringWriter velWriter = new StringWriter();
            SQLLoader.getEngine().mergeTemplate(template, ctx, (Writer)velWriter);
            String velOutput = velWriter.toString();
            ByteArrayInputStream sqlInput = new ByteArrayInputStream(velOutput.getBytes());
            this.sqlProps.load(sqlInput);
        }
        catch (IOException e) {
            throw new WrappedSQLException("unable to load sql properties from " + template, e);
        }
        catch (Exception e) {
            throw new WrappedSQLException("unable to merge template from " + template, e);
        }
    }

    private static synchronized VelocityEngine getEngine() throws Exception {
        if (ve == null) {
            ve = new VelocityEngine();
            Properties props = new Properties();
            ClassLoader cl = SQLLoader.class.getClassLoader();
            props.load(cl.getResourceAsStream(propsLoc));
            SQLLoader.setupVelocityLogger(props, logger);
            ve.init(props);
        }
        return ve;
    }

    public static void setupVelocityLogger(Properties velocityProps, Logger velocityLogger) {
        velocityProps.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
        velocityProps.setProperty(VELOCITY_LOGGER_NAME, logger.getName());
    }

    public boolean has(String propName) {
        return this.sqlProps.getProperty(propName) != null;
    }

    public String get(String propName) {
        return this.sqlProps.getProperty(propName);
    }

    public String[] getNamesForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this.sqlProps.keySet()) {
            if (!string.startsWith(prefix)) continue;
            list.add(string);
        }
        return list.toArray(new String[0]);
    }

    public Context getContext() {
        return this.context;
    }
}

