/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.sc.seis.fissuresUtil.database.seismogram.StationDataSummary;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RT130ReportFactory {
    private List stationDataSummaryList = new LinkedList();

    public RT130ReportFactory(Map channelIdWithTimeRanges, Map channelIdStringToChannelId) {
        this.organizeByStationCode(channelIdWithTimeRanges, channelIdStringToChannelId);
    }

    public void printGapDescription(PrintWriter reportStream) {
        Collections.sort(this.stationDataSummaryList);
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            ((StationDataSummary)it.next()).printGapDescription(reportStream);
            reportStream.println();
        }
    }

    public void printDaysOfCoverage(PrintWriter reportStream) {
        Collections.sort(this.stationDataSummaryList);
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            ((StationDataSummary)it.next()).printDaysOfCoverage(reportStream);
            reportStream.println();
        }
    }

    public List getStationCodes() {
        LinkedList<String> stationCodes = new LinkedList<String>();
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            stationCodes.add(((StationDataSummary)it.next()).getStationCode());
        }
        return stationCodes;
    }

    public List getStationDataSummaryList() {
        return this.stationDataSummaryList;
    }

    public List getSortedStationDataSummaryList() {
        Collections.sort(this.stationDataSummaryList);
        return this.stationDataSummaryList;
    }

    private void organizeByStationCode(Map channelIdWithTimeRanges, Map channelIdToChannel) {
        HashSet<String> stationCodes = new HashSet<String>();
        Iterator it = channelIdWithTimeRanges.keySet().iterator();
        while (it.hasNext()) {
            stationCodes.add(((ChannelId)channelIdToChannel.get((Object)((String)it.next()))).station_code);
        }
        for (String setStationCode : stationCodes) {
            HashMap<String, List> timeRangesByChannelCode = new HashMap<String, List>();
            for (String channelIdKey : channelIdWithTimeRanges.keySet()) {
                String stationCode = ((ChannelId)channelIdToChannel.get((Object)channelIdKey)).station_code;
                if (!stationCode.equals(setStationCode)) continue;
                String channelCode = ((ChannelId)channelIdToChannel.get((Object)channelIdKey)).channel_code;
                List timeRanges = (List)channelIdWithTimeRanges.get(channelIdKey);
                if (timeRangesByChannelCode.containsKey(channelCode)) {
                    List current = (List)timeRangesByChannelCode.get(channelCode);
                    current.addAll(timeRanges);
                    continue;
                }
                timeRangesByChannelCode.put(channelCode, timeRanges);
            }
            StationDataSummary temp = new StationDataSummary(setStationCode, timeRangesByChannelCode);
            this.stationDataSummaryList.add(temp);
        }
    }
}

