/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCParameterRef
extends JDBCTable {
    private PreparedStatement get;
    private PreparedStatement getDBId;
    private PreparedStatement insert;
    private JDBCSequence seq;

    public JDBCParameterRef(Connection conn) throws SQLException {
        super("parameterref", conn);
        Statement stmt = conn.createStatement();
        this.seq = new JDBCSequence(conn, "ParameterRefSeq");
        TableSetup.setup(this.getTableName(), conn, this, "edu/sc/seis/fissuresUtil/database/props/default.props");
        this.insert = conn.prepareStatement("INSERT INTO parameterref ( parameterid, parametera_id, parametercreator )VALUES (?,?,?)");
        this.get = conn.prepareStatement("SELECT parametera_id,  parametercreator FROM parameterref WHERE parameterid = ?");
        this.getDBId = conn.prepareStatement("SELECT parameterid FROM parameterref WHERE parametera_id = ? AND  parametercreator = ?");
    }

    public int put(ParameterRef parameterRef) throws SQLException {
        try {
            return this.getDBId(parameterRef);
        }
        catch (NotFound notFound) {
            int id = this.seq.next();
            this.insert.setInt(1, id);
            this.insert.setString(2, parameterRef.a_id);
            this.insert.setString(3, parameterRef.creator);
            this.insert.executeUpdate();
            return id;
        }
    }

    public int getDBId(ParameterRef parameterRef) throws SQLException, NotFound {
        this.getDBId.setString(1, parameterRef.a_id);
        this.getDBId.setString(2, parameterRef.creator);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            return rs.getInt("parameterid");
        }
        throw new NotFound("parameterref is not found");
    }

    public ParameterRef get(int id) throws SQLException, NotFound {
        this.get.setInt(1, id);
        ResultSet rs = this.get.executeQuery();
        if (rs.next()) {
            return new ParameterRef(rs.getString("parametera_id"), rs.getString("parametercreator"));
        }
        throw new NotFound("No ParameterRef is found for paameterid " + id);
    }
}

