/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockUtil {
    private static boolean warnServerFail = false;
    private static boolean warnBadBadClock = false;
    private static TimeInterval serverOffset = null;
    private static final TimeInterval ZERO_OFFSET = new TimeInterval(0.0, UnitImpl.SECOND);
    private static URL SEIS_SC_EDU_URL;
    private static MicroSecondDate OLD_DATE;
    private static TimeInterval ONE_DAY;
    private static TimeInterval ONE_WEEK;
    private static TimeInterval ONE_MONTH;
    private static final Logger logger;

    public static TimeInterval getTimeOffset() {
        if (serverOffset == null) {
            if (warnServerFail) {
                return ZERO_OFFSET;
            }
            try {
                serverOffset = ClockUtil.getServerTimeOffset();
            }
            catch (Throwable e) {
                ClockUtil.noGoClock(e);
                return ZERO_OFFSET;
            }
        }
        return serverOffset;
    }

    private static void noGoClock(Throwable e) {
        warnServerFail = true;
        logger.debug("Unable to make a connection to " + SEIS_SC_EDU_URL + " to verify system clock, assuming offset is zero.", e);
        logger.warn("Unable to make a connection to " + SEIS_SC_EDU_URL + " to verify system clock, assuming offset is zero.");
        MicroSecondDate localNow = new MicroSecondDate();
        if (!warnBadBadClock && OLD_DATE.after((Date)localNow)) {
            warnBadBadClock = true;
            GlobalExceptionHandler.handle("Unable to check the time from the server and the computer's clock is obviously wrong. Please reset the clock on your computer to be closer to real time. \nComputer Time=" + localNow + "\nTime checking url=" + SEIS_SC_EDU_URL, e);
        }
    }

    public static MicroSecondDate now() {
        return new MicroSecondDate().add(ClockUtil.getTimeOffset());
    }

    public static MicroSecondDate tomorrow() {
        return ClockUtil.now().add(ONE_DAY);
    }

    public static MicroSecondDate yesterday() {
        return ClockUtil.now().subtract(ONE_DAY);
    }

    public static MicroSecondDate lastWeek() {
        return ClockUtil.now().subtract(ONE_WEEK);
    }

    public static MicroSecondDate lastMonth() {
        return ClockUtil.now().subtract(ONE_MONTH);
    }

    public static MicroSecondDate wayPast() {
        return new MicroSecondDate(0L);
    }

    public static MicroSecondDate wayFuture() {
        return new MicroSecondDate(TimeUtils.future);
    }

    public static TimeInterval getServerTimeOffset() throws IOException {
        String str;
        HttpURLConnection conn = (HttpURLConnection)SEIS_SC_EDU_URL.openConnection();
        conn.setReadTimeout(10000);
        InputStream is = conn.getInputStream();
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(isReader);
        String timeStr = null;
        while ((str = bufferedReader.readLine()) != null) {
            timeStr = str;
        }
        MicroSecondDate localTime = new MicroSecondDate();
        Time serverTime = new Time();
        if (timeStr != null) {
            serverTime = new Time(timeStr);
        }
        return new TimeInterval(localTime, new MicroSecondDate(serverTime));
    }

    static {
        try {
            SEIS_SC_EDU_URL = new URL("http://www.seis.sc.edu/cgi-bin/date_time.pl");
        }
        catch (MalformedURLException e) {
            GlobalExceptionHandler.handle("Caught MalformedURL with seis data_time.pl URL. This should never happen.", e);
        }
        OLD_DATE = new ISOTime("2009-02-14T00:00:00.000Z").getDate();
        ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
        ONE_WEEK = new TimeInterval(7.0, UnitImpl.DAY);
        ONE_MONTH = new TimeInterval(30.0, UnitImpl.DAY);
        logger = LoggerFactory.getLogger(ClockUtil.class);
    }
}

