/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.cache.CacheByIdNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.NSNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.NSNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.RetryNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.RetryNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkAccess;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VestingNetworkFinder
extends ProxyNetworkFinder {
    private int numNetsAdded = 0;
    private transient boolean insideReset = false;
    private RetryStrategy handler;
    private Set<SoftReference<CacheNetworkAccess>> allKnownNetworkAccess = new HashSet<SoftReference<CacheNetworkAccess>>();
    private static final Logger logger = LoggerFactory.getLogger(VestingNetworkFinder.class);

    public VestingNetworkFinder(ProxyNetworkDC netDC, int numRetry) {
        this(netDC, new ClassicRetryStrategy(numRetry));
    }

    public VestingNetworkFinder(ProxyNetworkDC netDC, RetryStrategy handler) {
        super(new CacheByIdNetworkFinder(new RetryNetworkFinder(new NSNetworkFinder(netDC), handler)));
        this.handler = handler;
    }

    @Override
    public NetworkAccess retrieve_by_id(NetworkId id) throws NetworkNotFound {
        return this.vest(super.retrieve_by_id(id));
    }

    @Override
    public NetworkAccess[] retrieve_by_code(String code) throws NetworkNotFound {
        return this.vest(super.retrieve_by_code(code));
    }

    @Override
    public NetworkAccess[] retrieve_by_name(String name) throws NetworkNotFound {
        return this.vest(super.retrieve_by_name(name));
    }

    @Override
    public NetworkAccess[] retrieve_all() {
        return this.vest(super.retrieve_all());
    }

    public NetworkAccess[] vest(NetworkAccess[] accesses) {
        NetworkAccess[] vested = new CacheNetworkAccess[accesses.length];
        for (int i = 0; i < accesses.length; ++i) {
            vested[i] = this.vest(accesses[i]);
        }
        return vested;
    }

    public CacheNetworkAccess vest(NetworkAccess na) {
        CacheNetworkAccess cache = VestingNetworkFinder.vest(na, this, this.handler);
        this.addKnownNetworkAccess(cache);
        return cache;
    }

    private static CacheNetworkAccess vest(NetworkAccess na, VestingNetworkFinder vnf, RetryStrategy handler) {
        SynchronizedNetworkAccess synch = new SynchronizedNetworkAccess(na);
        JustToHaveServerAndName justToHaveServerAndName = new JustToHaveServerAndName(synch, vnf);
        RetryNetworkAccess retry = new RetryNetworkAccess((NetworkAccess)justToHaveServerAndName, handler);
        CacheNetworkAccess cache = new CacheNetworkAccess(retry);
        NetworkId id = cache.get_attributes().get_id();
        NSNetworkAccess nsNetworkAccess = new NSNetworkAccess(synch, id, vnf);
        retry.setNetworkAccess(nsNetworkAccess);
        cache.setNetworkAccess(retry);
        return cache;
    }

    public CacheNetworkAccess vest(NetworkAttrImpl attr) throws NetworkNotFound {
        NetworkId id = attr.get_id();
        logger.debug("(CacheById test) vest " + NetworkIdUtil.toString((NetworkId)id));
        NSNetworkAccess nsNetworkAccess = new NSNetworkAccess(id, this);
        RetryNetworkAccess retry = new RetryNetworkAccess((NetworkAccess)nsNetworkAccess, this.handler);
        CacheNetworkAccess cache = new CacheNetworkAccess(retry, attr);
        this.addKnownNetworkAccess(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addKnownNetworkAccess(CacheNetworkAccess cache) {
        Class<SynchronizedNetworkAccess> clazz = SynchronizedNetworkAccess.class;
        synchronized (SynchronizedNetworkAccess.class) {
            this.allKnownNetworkAccess.add(new SoftReference<CacheNetworkAccess>(cache));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ++this.numNetsAdded;
            if (this.numNetsAdded % 1000 != 0) return;
            clazz = SynchronizedNetworkAccess.class;
            synchronized (SynchronizedNetworkAccess.class) {
                Iterator<SoftReference<CacheNetworkAccess>> it = this.allKnownNetworkAccess.iterator();
                while (it.hasNext()) {
                    SoftReference<CacheNetworkAccess> net = it.next();
                    if (net.get() != null) continue;
                    it.remove();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Class<SynchronizedNetworkAccess> clazz = SynchronizedNetworkAccess.class;
        synchronized (SynchronizedNetworkAccess.class) {
            super.reset();
            if (!this.insideReset) {
                this.insideReset = true;
                HashSet<SoftReference<CacheNetworkAccess>> allKnownNetworkAccessCopy = new HashSet<SoftReference<CacheNetworkAccess>>();
                allKnownNetworkAccessCopy.addAll(this.allKnownNetworkAccess);
                Iterator it = allKnownNetworkAccessCopy.iterator();
                while (it.hasNext()) {
                    SoftReference net = (SoftReference)it.next();
                    CacheNetworkAccess cnet = (CacheNetworkAccess)net.get();
                    if (cnet != null) {
                        cnet.reset();
                        continue;
                    }
                    it.remove();
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.insideReset = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public InterfaceDef _get_interface() {
        throw new RuntimeException("should never be called");
    }

    public Object _get_component() {
        throw new RuntimeException("should never be called");
    }

    static class JustToHaveServerAndName
    extends ProxyNetworkAccess {
        private VestingNetworkFinder vnf;

        public JustToHaveServerAndName(NetworkAccess net, VestingNetworkFinder vnf) {
            super(net);
            this.vnf = vnf;
        }

        protected NetworkAttrImpl setSource(NetworkAttr attr) {
            NetworkAttrImpl impl = (NetworkAttrImpl)attr;
            impl.setSourceServerDNS(this.getServerDNS());
            impl.setSourceServerName(this.getServerName());
            return impl;
        }

        @Override
        public NetworkAttr get_attributes() {
            NetworkAttrImpl impl = (NetworkAttrImpl)super.get_attributes();
            impl.setSourceServerDNS(this.getServerDNS());
            impl.setSourceServerName(this.getServerName());
            return impl;
        }

        @Override
        public String getServerDNS() {
            return this.vnf.getServerDNS();
        }

        @Override
        public String getServerName() {
            return this.vnf.getServerName();
        }
    }
}

