/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.AuditElement;
import edu.iris.Fissures.IfNetwork.Calibration;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelIdIterHolder;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.TimeCorrection;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryNetworkAccess
extends ProxyNetworkAccess {
    private RetryStrategy handler;
    private static final Logger logger = LoggerFactory.getLogger(RetryNetworkAccess.class);

    public RetryNetworkAccess(NetworkAccess net, int retry) {
        this(net, new ClassicRetryStrategy(retry));
    }

    public RetryNetworkAccess(NetworkAccess net, RetryStrategy handler) {
        super(net);
        this.handler = handler;
    }

    @Override
    public NetworkAttr get_attributes() {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().get_attributes();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                NetworkAttr result = this.getNetworkAccess().get_attributes();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public AuditElement[] get_audit_trail_for_channel(ChannelId id) throws ChannelNotFound, NotImplemented {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().get_audit_trail_for_channel(id);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                AuditElement[] result = this.getNetworkAccess().get_audit_trail_for_channel(id);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public AuditElement[] get_audit_trail() throws NotImplemented {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().get_audit_trail();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                AuditElement[] result = this.getNetworkAccess().get_audit_trail();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Channel[] locate_channels(Area the_area, SamplingRange sampling, OrientationRange orientation) {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().locate_channels(the_area, sampling, orientation);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Channel[] result = this.getNetworkAccess().locate_channels(the_area, sampling, orientation);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public ChannelId[] retrieve_all_channels(int seq_max, ChannelIdIterHolder iter) {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_all_channels(seq_max, iter);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                ChannelId[] result = this.getNetworkAccess().retrieve_all_channels(seq_max, iter);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Calibration[] retrieve_calibrations(ChannelId id, TimeRange the_time) throws ChannelNotFound, NotImplemented {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_calibrations(id, the_time);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Calibration[] result = this.getNetworkAccess().retrieve_calibrations(id, the_time);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Channel retrieve_channel(ChannelId id) throws ChannelNotFound {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_channel(id);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Channel result = this.getNetworkAccess().retrieve_channel(id);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Channel[] retrieve_channels_by_code(String station_code, String site_code, String channel_code) throws ChannelNotFound {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_channels_by_code(station_code, site_code, channel_code);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Channel[] result = this.getNetworkAccess().retrieve_channels_by_code(station_code, site_code, channel_code);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Channel[] retrieve_for_station(StationId p1) {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_for_station(p1);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Channel[] result = this.getNetworkAccess().retrieve_for_station(p1);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public ChannelId[] retrieve_grouping(ChannelId id) throws ChannelNotFound {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_grouping(id);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                ChannelId[] result = this.getNetworkAccess().retrieve_grouping(id);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public ChannelId[][] retrieve_groupings() {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_groupings();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                ChannelId[][] result = this.getNetworkAccess().retrieve_groupings();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Instrumentation retrieve_instrumentation(ChannelId id, Time the_time) throws ChannelNotFound {
        Throwable latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_instrumentation(id, the_time);
        }
        catch (UNKNOWN t) {
            latest = t;
            logger.warn("UNKNOWN on retrieve_instrumentation(" + ChannelIdUtil.toString((ChannelId)id) + ", " + the_time.date_time);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, (SystemException)latest)) {
            try {
                Instrumentation result = this.getNetworkAccess().retrieve_instrumentation(id, the_time);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public Station[] retrieve_stations() {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_stations();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                Station[] result = this.getNetworkAccess().retrieve_stations();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public TimeCorrection[] retrieve_time_corrections(ChannelId id, TimeRange time_range) throws ChannelNotFound, NotImplemented {
        SystemException latest;
        int count = 0;
        try {
            return this.getNetworkAccess().retrieve_time_corrections(id, time_range);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                TimeCorrection[] result = this.getNetworkAccess().retrieve_time_corrections(id, time_range);
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    private boolean shouldRetry(int count, SystemException t) {
        return this.handler.shouldRetry(t, this, count);
    }
}

