/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.VestingNetworkFinder;
import org.omg.CORBA.TRANSIENT;

public class NSNetworkAccess
extends ProxyNetworkAccess {
    private VestingNetworkFinder vnf;
    private NetworkId id;

    public NSNetworkAccess(NetworkId id, VestingNetworkFinder vnf) throws NetworkNotFound {
        this(NSNetworkAccess.getAccess(id, vnf), id, vnf);
    }

    public NSNetworkAccess(SynchronizedNetworkAccess na, NetworkId id, VestingNetworkFinder vnf) {
        super(na);
        this.id = id;
        this.vnf = vnf;
    }

    @Override
    public void reset() {
        try {
            super.reset();
            this.vnf.reset();
            this.setNetworkAccess(NSNetworkAccess.getAccess(this.id, this.vnf));
        }
        catch (NetworkNotFound e) {
            TRANSIENT t = new TRANSIENT("Unable to find the network to reset it");
            t.initCause((Throwable)e);
            throw t;
        }
    }

    private static SynchronizedNetworkAccess getAccess(NetworkId id, VestingNetworkFinder vnf) throws NetworkNotFound {
        return new SynchronizedNetworkAccess(((ProxyNetworkAccess)vnf.retrieve_by_id(id)).getCorbaObject());
    }

    protected NetworkAttrImpl setSource(NetworkAttr attr) {
        NetworkAttrImpl impl = (NetworkAttrImpl)attr;
        impl.setSourceServerDNS(this.getServerDNS());
        impl.setSourceServerName(this.getServerName());
        return impl;
    }

    @Override
    public NetworkAttr get_attributes() {
        return this.setSource(super.get_attributes());
    }

    @Override
    public Channel[] locate_channels(Area the_area, SamplingRange sampling, OrientationRange orientation) {
        Channel[] chans = super.locate_channels(the_area, sampling, orientation);
        for (int i = 0; i < chans.length; ++i) {
            this.setSource(chans[i].getSite().getStation().getNetworkAttr());
        }
        return chans;
    }

    @Override
    public Channel retrieve_channel(ChannelId id) throws ChannelNotFound {
        Channel chan = super.retrieve_channel(id);
        this.setSource(chan.getSite().getStation().getNetworkAttr());
        return chan;
    }

    @Override
    public Channel[] retrieve_channels_by_code(String station_code, String site_code, String channel_code) throws ChannelNotFound {
        Channel[] chans = super.retrieve_channels_by_code(station_code, site_code, channel_code);
        for (int i = 0; i < chans.length; ++i) {
            this.setSource(chans[i].getSite().getStation().getNetworkAttr());
        }
        return chans;
    }

    @Override
    public Channel[] retrieve_for_station(StationId p1) {
        Channel[] chans = super.retrieve_for_station(p1);
        for (int i = 0; i < chans.length; ++i) {
            this.setSource(chans[i].getSite().getStation().getNetworkAttr());
        }
        return chans;
    }

    @Override
    public Station[] retrieve_stations() {
        Station[] sta = super.retrieve_stations();
        for (int i = 0; i < sta.length; ++i) {
            this.setSource(sta[i].getNetworkAttr());
        }
        return sta;
    }

    @Override
    public String getServerDNS() {
        return this.vnf.getServerDNS();
    }

    @Override
    public String getServerName() {
        return this.vnf.getServerName();
    }
}

