/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheNetworkAccess
extends ProxyNetworkAccess {
    private Map<String, Site> knownSites = Collections.synchronizedMap(new HashMap());
    private Map<String, Station> knownStations = Collections.synchronizedMap(new HashMap());
    protected NetworkAttrImpl attr;
    protected Station[] stations;
    private HashMap<String, SoftReference<Channel[]>> channelMap = new HashMap();
    private HashMap<String, List<SensitivityHolder>> sensMap = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(CacheNetworkAccess.class);

    public CacheNetworkAccess(NetworkAccess net) {
        super(net);
    }

    public CacheNetworkAccess(NetworkAccess net, NetworkAttrImpl attr) {
        super(net);
        this.attr = attr;
    }

    @Override
    public void reset() {
        this.attr = null;
        this.stations = null;
        this.channelMap.clear();
        this.knownStations.clear();
        this.knownSites.clear();
        this.sensMap.clear();
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkAttrImpl get_attributes() {
        CacheNetworkAccess cacheNetworkAccess = this;
        synchronized (cacheNetworkAccess) {
            if (this.attr == null) {
                this.attr = (NetworkAttrImpl)this.getNetworkAccess().get_attributes();
                NetworkAttr.intern((NetworkAttr)this.attr);
            }
        }
        return this.attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Station[] retrieve_stations() {
        Map<String, Station> map = this.knownStations;
        synchronized (map) {
            if (this.stations == null) {
                this.stations = this.getNetworkAccess().retrieve_stations();
                for (int i = 0; i < this.stations.length; ++i) {
                    this.stations[i] = Station.intern((Station)this.stations[i]);
                }
            }
        }
        return this.stations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel[] retrieve_for_station(StationId id) {
        String idStr = StationIdUtil.toString((StationId)id);
        HashMap<String, SoftReference<Channel[]>> hashMap = this.channelMap;
        synchronized (hashMap) {
            Channel[] chans;
            SoftReference<Channel[]> chansRef = this.channelMap.get(idStr);
            Channel[] channelArray = chans = chansRef != null ? chansRef.get() : null;
            if (chans == null) {
                chans = this.getNetworkAccess().retrieve_for_station(id);
                for (int i = 0; i < chans.length; ++i) {
                    Channel.intern((Channel)chans[i]);
                }
                if (chans.length == 0) {
                    logger.debug("Got 0 channels for station " + StationIdUtil.toString((StationId)id) + " in network " + NetworkIdUtil.toString((NetworkId)this.get_attributes().get_id()));
                }
                this.channelMap.put(idStr, new SoftReference<Channel[]>(chans));
                return chans;
            }
            return chans;
        }
    }

    @Override
    public Channel retrieve_channel(ChannelId id) throws ChannelNotFound {
        String staIdStr = NetworkIdUtil.toString((NetworkId)id.network_id) + "." + id.station_code;
        for (String staId : this.channelMap.keySet()) {
            Channel[] chans;
            if (!staId.startsWith(staIdStr)) continue;
            SoftReference<Channel[]> sr = this.channelMap.get(staId);
            Channel[] channelArray = chans = sr != null ? sr.get() : null;
            if (chans == null) {
                return super.retrieve_channel(id);
            }
            for (int i = 0; i < chans.length; ++i) {
                if (!ChannelIdUtil.areEqual((ChannelId)id, (ChannelId)chans[i].getId())) continue;
                return chans[i];
            }
        }
        return super.retrieve_channel(id);
    }

    @Override
    public Instrumentation retrieve_instrumentation(ChannelId id, Time the_time) throws ChannelNotFound {
        Instrumentation inst = this.getNetworkAccess().retrieve_instrumentation(id, the_time);
        if (inst.the_response.stages.length != 0) {
            SensitivityHolder holder = this.extractExistingHolder(id, the_time);
            List<SensitivityHolder> sensForChannel = this.extractSensForChannel(id);
            if (holder == null) {
                holder = new SensitivityHolder(inst);
                sensForChannel.add(holder);
            } else {
                holder.updateHoldings(inst);
            }
        } else {
            logger.warn("Instrumentation has no stages, units cannot be determined, sensitivity cache not updated.");
        }
        return inst;
    }

    private SensitivityHolder extractExistingHolder(ChannelId id, Time time) {
        MicroSecondDate date = new MicroSecondDate(time);
        List<SensitivityHolder> sensForChannel = this.extractSensForChannel(id);
        for (SensitivityHolder holder : sensForChannel) {
            if (!holder.range.contains(date)) continue;
            return holder;
        }
        return null;
    }

    private List<SensitivityHolder> extractSensForChannel(ChannelId id) {
        String idString = ChannelIdUtil.toString((ChannelId)id);
        List<SensitivityHolder> sensForChannel = this.sensMap.get(idString);
        if (sensForChannel == null) {
            sensForChannel = new ArrayList<SensitivityHolder>();
            this.sensMap.put(idString, sensForChannel);
        }
        return sensForChannel;
    }

    private SensitivityHolder getFilledHolder(ChannelId id, Time the_time) throws ChannelNotFound {
        SensitivityHolder holder = this.extractExistingHolder(id, the_time);
        if (holder == null) {
            this.retrieve_instrumentation(id, the_time);
            return this.extractExistingHolder(id, the_time);
        }
        return holder;
    }

    @Override
    public Sensitivity retrieve_sensitivity(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).sensitivity;
    }

    @Override
    public Unit retrieve_initial_units(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).initialUnits;
    }

    @Override
    public Unit retrieve_final_units(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).finalUnits;
    }

    class SensitivityHolder {
        Sensitivity sensitivity;
        Unit initialUnits;
        Unit finalUnits;
        MicroSecondTimeRange range;

        public SensitivityHolder(Instrumentation inst) {
            this.updateHoldings(inst);
        }

        private void updateHoldings(Instrumentation inst) {
            this.sensitivity = inst.the_response.the_sensitivity;
            Stage[] stages = inst.the_response.stages;
            this.initialUnits = stages[0].input_units;
            this.finalUnits = stages[stages.length - 1].output_units;
            this.range = new MicroSecondTimeRange(inst.effective_time);
        }
    }
}

