/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfEvent.OriginNotFound;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEvent
extends ProxyEventAccessOperations {
    private int dbid;
    protected EventAttr attr;
    protected Origin[] origins;
    protected OriginImpl preferred;
    private static final Logger logger = LoggerFactory.getLogger(CacheEvent.class);

    protected CacheEvent() {
    }

    public CacheEvent(EventAttr attr, Origin preferred) {
        this(attr, (OriginImpl)preferred);
    }

    public CacheEvent(EventAttr attr, OriginImpl preferred) {
        this(attr, new Origin[]{preferred}, preferred);
    }

    public CacheEvent(EventAttr attr, Origin[] origins, OriginImpl preferred) {
        if (attr == null) {
            throw new IllegalArgumentException("EventAttr cannot be null");
        }
        if (origins == null) {
            throw new IllegalArgumentException("origins cannot be null");
        }
        this.attr = attr;
        this.origins = origins;
        this.preferred = preferred;
    }

    public CacheEvent(EventAccessOperations event) {
        if (event == null) {
            throw new IllegalArgumentException("EventAccess cannot be null");
        }
        this.setEventAccess(event);
        this.get_attributes();
        try {
            this.getPreferred();
        }
        catch (NoPreferredOrigin noPreferredOrigin) {
            // empty catch block
        }
    }

    @Override
    public EventAttr get_attributes() {
        if (this.attr == null && this.event != null) {
            this.attr = this.event.get_attributes();
        }
        if (this.attr == null) {
            this.attr = EventAttrImpl.createEmpty();
        }
        return this.attr;
    }

    public EventAttrImpl getAttributes() {
        return (EventAttrImpl)this.get_attributes();
    }

    @Override
    public Origin[] get_origins() {
        if (this.origins == null && this.event != null) {
            this.origins = this.event.get_origins();
        }
        if (this.origins == null) {
            try {
                this.origins = new OriginImpl[]{this.getPreferred()};
            }
            catch (NoPreferredOrigin e) {
                this.origins = new Origin[0];
            }
        }
        return this.origins;
    }

    public Origin[] getOrigins() {
        return this.get_origins();
    }

    protected void setOrigins(Origin[] origins) {
        this.origins = origins;
    }

    @Override
    public Origin get_origin(String the_origin) throws OriginNotFound {
        if (this.event != null) {
            return this.event.get_origin(the_origin);
        }
        for (int i = 0; i < this.origins.length; ++i) {
            if (!this.origins[i].get_id().equals(the_origin)) continue;
            return this.origins[i];
        }
        throw new OriginNotFound();
    }

    @Override
    public Origin get_preferred_origin() throws NoPreferredOrigin {
        return this.getPreferred();
    }

    public OriginImpl getPreferred() throws NoPreferredOrigin {
        if (this.preferred == null) {
            if (this.event != null) {
                this.preferred = (OriginImpl)this.event.get_preferred_origin();
            } else {
                throw new NoPreferredOrigin();
            }
        }
        return this.preferred;
    }

    protected void setPreferred(OriginImpl o) {
        this.preferred = o;
    }

    public boolean isLoaded() {
        return this.attr != null && this.preferred != null;
    }

    public boolean hasDbid() {
        return this.dbid > -1;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void setDbid(int id) {
        this.dbid = id;
    }

    public InterfaceDef _get_interface() {
        throw new RuntimeException("should never be called");
    }

    public Object _get_component() {
        throw new RuntimeException("should never be called");
    }
}

