/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import edu.sc.seis.fissuresUtil.bag.Statistics;

public class RTrend
implements LocalSeismogramFunction {
    @Override
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (seis.can_convert_to_float()) {
            float[] fSeries = seis.get_as_floats();
            return new LocalSeismogramImpl((SeismogramAttr)seis, this.apply(fSeries));
        }
        double[] dSeries = seis.get_as_doubles();
        return new LocalSeismogramImpl((SeismogramAttr)seis, this.apply(dSeries));
    }

    public float[] apply(float[] data) {
        float[] out = new float[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(float[] data) {
        Statistics stat = new Statistics(data);
        double[] trend = stat.linearLeastSquares();
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] - (float)(trend[0] + (double)i * trend[1]);
        }
    }

    public double[] apply(double[] data) {
        double[] out = new double[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(double[] data) {
        Statistics stat = new Statistics(data);
        double[] trend = stat.linearLeastSquares();
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] - (trend[0] + (double)i * trend[1]);
        }
    }

    public int[] apply(int[] data) {
        int[] out = new int[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(int[] data) {
        Statistics stat = new Statistics(data);
        double[] trend = stat.linearLeastSquares();
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] - (int)Math.round(trend[0] + (double)i * trend[1]);
        }
    }

    public short[] apply(short[] data) {
        short[] out = new short[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(short[] data) {
        Statistics stat = new Statistics(data);
        double[] trend = stat.linearLeastSquares();
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = (short)(data[n] - (short)Math.round(trend[0] + (double)i * trend[1]));
        }
    }
}

