/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import edu.sc.seis.fissuresUtil.bag.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMean
implements LocalSeismogramFunction {
    private static final Logger logger = LoggerFactory.getLogger(RMean.class);

    @Override
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (seis.can_convert_to_float()) {
            float[] fSeries = seis.get_as_floats();
            return new LocalSeismogramImpl((SeismogramAttr)seis, RMean.removeMean(fSeries));
        }
        double[] dSeries = seis.get_as_doubles();
        return new LocalSeismogramImpl((SeismogramAttr)seis, RMean.removeMean(dSeries));
    }

    public static float[] removeMean(float[] data) {
        float[] out = new float[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        RMean.removeMeanInPlace(out);
        return out;
    }

    public static void removeMeanInPlace(float[] data) {
        Statistics stat = new Statistics(data);
        float mean = (float)stat.mean();
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] - mean;
        }
    }

    public static double[] removeMean(double[] data) {
        double[] out = new double[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        RMean.removeMeanInPlace(out);
        return out;
    }

    public static void removeMeanInPlace(double[] data) {
        Statistics stat = new Statistics(data);
        double mean = stat.mean();
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] - mean;
        }
    }

    public static int[] removeMean(int[] data) {
        int[] out = new int[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        RMean.removeMeanInPlace(out);
        return out;
    }

    public static void removeMeanInPlace(int[] data) {
        Statistics stat = new Statistics(data);
        int mean = Math.round((float)stat.mean());
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] - mean;
        }
    }

    public static short[] removeMean(short[] data) {
        short[] out = new short[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        RMean.removeMeanInPlace(out);
        return out;
    }

    public static void removeMeanInPlace(short[] data) {
        Statistics stat = new Statistics(data);
        short mean = (short)Math.round((float)stat.mean());
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = (short)(data[n] - mean);
        }
    }
}

