/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;

public class Pad
implements LocalSeismogramFunction {
    protected TimeInterval timeInterval = null;
    protected int padPoints = 0;

    public Pad(TimeInterval padTime) {
        this.timeInterval = padTime;
    }

    public Pad(int padPoints) {
        this.padPoints = padPoints;
    }

    @Override
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws Exception {
        if (this.timeInterval != null) {
            return this.pad(seis, this.timeInterval);
        }
        return this.pad(seis, this.padPoints);
    }

    public LocalSeismogramImpl pad(LocalSeismogramImpl seis, TimeInterval padSize) throws FissuresException {
        SamplingImpl samp = SamplingImpl.createSamplingImpl((Sampling)seis.sampling_info);
        double period = samp.getPeriod().convertTo(UnitImpl.SECOND).getValue();
        UnitImpl sec_per_sec = UnitImpl.divide((UnitImpl)UnitImpl.SECOND, (UnitImpl)UnitImpl.SECOND, (String)"sec per sec");
        int padPoints = (int)Math.ceil(padSize.divideBy((QuantityImpl)samp.getPeriod()).convertTo(sec_per_sec).get_value());
        return this.pad(seis, padPoints);
    }

    public LocalSeismogramImpl pad(LocalSeismogramImpl seis, int padPoints) throws FissuresException {
        LocalSeismogramImpl outSeis;
        int newSize = seis.getNumPoints() + padPoints;
        if (seis.can_convert_to_short()) {
            short[] outS = new short[newSize];
            short[] inS = seis.get_as_shorts();
            System.arraycopy(inS, 0, outS, 0, inS.length);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outS);
        } else if (seis.can_convert_to_long()) {
            int[] outI = new int[newSize];
            int[] inI = seis.get_as_longs();
            System.arraycopy(inI, 0, outI, 0, inI.length);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outI);
        } else if (seis.can_convert_to_float()) {
            float[] outF = new float[newSize];
            float[] inF = seis.get_as_floats();
            System.arraycopy(inF, 0, outF, 0, inF.length);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outF);
        } else {
            double[] outD = new double[newSize];
            double[] inD = seis.get_as_doubles();
            System.arraycopy(inD, 0, outD, 0, inD.length);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outD);
        }
        return outSeis;
    }
}

