/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Arithmatic;
import edu.sc.seis.fissuresUtil.bag.ChannelSeismogram;

public class NegativeSensitivity {
    public static boolean check(Sensitivity sensitivity) {
        return sensitivity.sensitivity_factor < 0.0f;
    }

    public static boolean check(QuantityImpl sensitivity) {
        return sensitivity.value < 0.0;
    }

    public static ChannelSeismogram correct(ChannelImpl chan, LocalSeismogramImpl seis, Sensitivity sensitivity) throws FissuresException {
        if (NegativeSensitivity.check(sensitivity)) {
            return new ChannelSeismogram(chan, (LocalSeismogram)Arithmatic.mul(seis, -1.0f), new Sensitivity(-1.0f * sensitivity.sensitivity_factor, sensitivity.frequency));
        }
        return new ChannelSeismogram(chan, (LocalSeismogram)seis, sensitivity);
    }
}

