/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.terrain;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.util.Debug;
import java.awt.Color;

public class LOSGenerator {
    static final int PRECISE = 0;
    static final int GOODENOUGH = 1;
    static final int AZIMUTH = 2;
    static final int DEFAULT_INVISIBLE = new Color(0, 0, 0, 0).getRGB();
    static final int DEFAULT_VISIBLE = new Color(0, 255, 0, 255).getRGB();
    static final int DEFAULT_MAYBEVISIBLE = new Color(255, 255, 0, 255).getRGB();
    protected int INVISIBLE = DEFAULT_INVISIBLE;
    protected int VISIBLE = DEFAULT_VISIBLE;
    protected int MAYBEVISIBLE = DEFAULT_MAYBEVISIBLE;
    DTEDFrameCache dtedCache = null;

    public LOSGenerator() {
    }

    public LOSGenerator(DTEDFrameCache cache) {
        this.setDtedCache(cache);
    }

    public void setDtedCache(DTEDFrameCache cache) {
        this.dtedCache = cache;
    }

    public DTEDFrameCache getDtedCache() {
        return this.dtedCache;
    }

    public boolean isLOS(LatLonPoint startLLP, int startObjHeight, LatLonPoint endLLP, int endObjHeight, int numPoints) {
        boolean ret = false;
        if (Debug.debugging("los")) {
            Debug.output("LOSGenerator.isLOS: " + startLLP + " at height:" + startObjHeight + ", " + endLLP + " at height:" + endObjHeight + ", numPoints = " + numPoints);
        }
        if (this.dtedCache == null) {
            return ret;
        }
        int startTotalHeight = startObjHeight + this.dtedCache.getElevation(startLLP.getLatitude(), startLLP.getLongitude());
        float[] llpoints = GreatCircle.great_circle(startLLP.radlat_, startLLP.radlon_, endLLP.radlat_, endLLP.radlon_, numPoints, true);
        LatLonPoint llp = new LatLonPoint();
        int size = llpoints.length;
        double losSlope = -1.5707963705062866;
        int i = 0;
        while (i < size) {
            llp.setLatLon(llpoints[i], llpoints[i + 1], true);
            int height = 0;
            if (i >= size - 2) {
                height = endObjHeight;
            }
            double slope = this.calculateLOSSlope(startLLP, startTotalHeight, llp, height);
            if (Debug.debugging("losdetail")) {
                Debug.output("   LOS:" + i / 2 + " - slope = " + slope + " at height of point: " + height);
            }
            if (losSlope < slope) {
                losSlope = slope;
                ret = true;
            } else {
                ret = false;
            }
            i += 2;
        }
        if (Debug.debugging("los")) {
            Debug.output("LOSGenerator - points " + (ret ? "" : " NOT ") + " in LOS");
        }
        return ret;
    }

    public double calculateLOSSlope(LatLonPoint startLLP, int startTotalHeight, LatLonPoint endLLP, int endObjHeight) {
        if (this.dtedCache == null) {
            return 0.0;
        }
        float arc_dist = GreatCircle.spherical_distance(startLLP.radlat_, startLLP.radlon_, endLLP.radlat_, endLLP.radlon_);
        int endTotalHeight = endObjHeight + this.dtedCache.getElevation(endLLP.getLatitude(), endLLP.getLongitude());
        return this.calculateLOSSlope(startTotalHeight, endTotalHeight, arc_dist);
    }

    public double calculateLOSSlope(int startTotalHeight, int endTotalHeight, float arc_dist) {
        double ret = 0.0;
        double P = Math.sin(arc_dist) * (double)((float)endTotalHeight + 6378137.0f);
        double xPrime = Math.cos(arc_dist) * (double)((float)endTotalHeight + 6378137.0f);
        double cutoff = (float)startTotalHeight + 6378137.0f;
        double bottom = cutoff - xPrime;
        ret = 1.5707963267948966 - Math.atan(bottom / P);
        return ret;
    }
}

