/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.BeanBox;
import com.bbn.openmap.tools.beanbox.PropertySheetPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JDialog;

public class GenericPropertySheet
extends JDialog
implements PropertyChangeListener {
    protected PropertySheetPanel panel;
    protected PropertyEditor editor;
    protected Object targetBean;
    protected BeanBox beanBox;
    protected Rectangle bounds;
    protected int numEditorsToDisplay;

    public GenericPropertySheet(boolean isModal, String title) {
        super((Frame)null, title, isModal);
    }

    public GenericPropertySheet(Object target, int x, int y, PropertyEditor pe, BeanBox beanBox) {
        this(false, target, new Rectangle(x, y, 100, 100), pe, beanBox);
    }

    public GenericPropertySheet(boolean isModal, Object target, Rectangle bounds, PropertyEditor pe, BeanBox beanBox) {
        super((Frame)null, "Properties - <initializing...>", isModal);
        this.targetBean = target;
        if (bounds == null) {
            this.bounds = new Rectangle(0, 0, 100, 100);
        } else {
            this.bounds = new Rectangle();
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.width = bounds.width > 0 ? bounds.width : 100;
            this.bounds.height = bounds.height > 0 ? bounds.height : 100;
        }
        this.editor = pe;
        this.beanBox = beanBox;
        this.init();
        this.getContentPane().add(this.panel);
    }

    protected void init() {
        this.setBackground(Color.lightGray);
        this.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.initTitle();
        this.initPanel();
        this.addWindowListener();
    }

    protected void initPanel() {
        this.panel = new PropertySheetPanel(this);
        if (this.targetBean != null) {
            this.panel.setTarget(this.targetBean);
        }
    }

    protected void initTitle() {
        block2: {
            if (this.targetBean == null) break block2;
            Class<?> beanClass = this.targetBean.getClass();
            try {
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                String label = bi.getBeanDescriptor().getDisplayName();
                this.setTitle(label + " Properties");
            }
            catch (Exception ex) {
                System.err.println("GenericPropertySheet: couldn't find BeanInfo for " + beanClass);
                ex.printStackTrace();
            }
        }
    }

    protected void addWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (GenericPropertySheet.this.beanBox != null) {
                    GenericPropertySheet.this.beanBox.editComplete(GenericPropertySheet.this.targetBean);
                }
                GenericPropertySheet.this.setVisible(false);
            }
        });
    }

    protected PropertySheetPanel getPropertySheetPanel() {
        return this.panel;
    }

    protected void setFrameSize() {
        int approxControlBarWidth = 60;
        int approxTitleBarHeight = 20;
        int approxIconWidth = 20;
        int approxFontWidth = 8;
        int approxFontHeight = 17;
        int approxTitleWidth = this.getTitle() == null ? approxControlBarWidth * 2 : approxIconWidth + this.getTitle().length() * approxFontWidth + approxControlBarWidth;
        int width = approxTitleWidth > 220 ? approxTitleWidth : 220;
        this.setSize(width, approxTitleBarHeight + this.numEditorsToDisplay * approxFontHeight * 2);
    }

    protected void setNumEditorsToDisplay(int numEditorsToDisplay) {
        this.numEditorsToDisplay = numEditorsToDisplay;
    }

    public void setTarget(Object bean) {
        this.panel.setTarget(bean);
        Class<?> beanClass = bean.getClass();
        try {
            BeanInfo bi = Introspector.getBeanInfo(beanClass);
            String label = bi.getBeanDescriptor().getDisplayName();
            this.setTitle("Properties for " + label);
        }
        catch (Exception ex) {
            System.err.println("GenericPropertySheet: couldn't find BeanInfo for " + beanClass);
            ex.printStackTrace();
        }
        this.setVisible(true);
        this.targetBean = bean;
    }

    private void setCustomizer(Customizer c) {
        this.panel.setCustomizer(c);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.panel.wasModified(evt);
        if (this.editor != null) {
            this.editor.setValue(this.targetBean);
        }
        if (this.beanBox != null) {
            this.beanBox.beanChanged(this.targetBean, evt.getPropertyName());
        }
    }
}

