/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class LLXYView
extends LLXY {
    public static final transient String LLXYViewName = "EPSG-4326";
    public static final transient int LLXYViewType = 6303;
    private LLXYViewHelper helper;
    protected LatLonPoint uCtr;
    protected float uCtrLat;
    protected float uCtrLon;
    protected int sCtrX;
    protected int sCtrY;
    protected int uCtrX;
    protected int uCtrY;
    protected int dUSX;
    protected int dUSY;

    public LLXYView(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 6303);
        this.computeParameters();
    }

    public String toString() {
        return "LLXYView[" + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeParameters() {
        Debug.message("LLXYView", "LLXYView.computeParameters()");
        super.computeParameters();
        this.hy = this.height / 2;
        this.wx = this.width / 2;
        this.cLon = ProjMath.radToDeg(this.ctrLon);
        if (this.uCtr == null) {
            this.uCtrLat = 0.0f;
            this.uCtrLon = 0.0f;
            this.uCtr = new LatLonPoint(this.uCtrLat, this.uCtrLon);
        }
        if (this.helper == null) {
            this.helper = new LLXYViewHelper(this.uCtr, this.scale, this.width, this.height);
        }
        LLXYViewHelper lLXYViewHelper = this.helper;
        synchronized (lLXYViewHelper) {
            super.computeParameters();
            Point temp = new Point();
            this.helper.setAllParams(this.pixelsPerMeter, this.planetRadius, this.planetPixelRadius, this.planetPixelCircumference, this.minscale, this.maxscale, this.scale, this.scaled_radius, this.width, this.height, this.uCtrLat, this.uCtrLon);
            this.helper.forward(this.ctrLat, this.ctrLon, temp, true);
            this.sCtrX = temp.x;
            this.sCtrY = temp.y;
            this.helper.forward(this.uCtrLat, this.uCtrLon, temp);
            this.uCtrX = temp.x;
            this.uCtrY = temp.y;
            this.dUSX = this.sCtrX - this.uCtrX;
            this.dUSY = this.sCtrY - this.uCtrY;
        }
        Debug.message("LLXYView", "User Center LL: " + this.uCtrLon + "," + this.uCtrLat + " User Center xy: " + this.uCtrX + "," + this.uCtrY + " Screen Center LL: " + ProjMath.radToDeg(this.ctrLon) + "," + ProjMath.radToDeg(this.ctrLat) + " Screen Center xy: " + this.sCtrX + "," + this.sCtrY + " Screen wh: " + this.width + "x" + this.height + " Screen halfwh: " + this.wx + "x" + this.hy + " Delta xy: " + this.dUSX + "," + this.dUSY);
    }

    public Point forward(LatLonPoint pt, Point p) {
        this.helper.forward(pt, p);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        if (Debug.debugging("LLXYViewf")) {
            Debug.output("LLXYView.forward(pt.lon_:" + pt.getLongitude() + ", pt.lat_:" + pt.getLatitude() + ")\n" + "LLXYView.forward   x:" + p.x + ", y:" + p.y);
        }
        return p;
    }

    public Point forward(float lat, float lon, Point p) {
        this.helper.forward(lat, lon, p);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        if (Debug.debugging("LLXYViewf")) {
            Debug.output("LLXYView.forward(lon:" + lon + ", lat:" + lat + ")\n" + "LLXYView.forward   x:" + p.x + ", y:" + p.y + " ctrLon:" + this.cLon + " wx:" + this.wx + " hy:" + this.hy);
        }
        return p;
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        this.helper.forward(lat, lon, p, isRadian);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        if (Debug.debugging("LLXYViewf")) {
            Debug.output("LLXYView.forward(lon:" + ProjMath.radToDeg(lon) + ", lat:" + ProjMath.radToDeg(lat) + " isRadian:" + isRadian + ")\n" + "LLXYView.forward   x:" + p.x + ", y:" + p.y + " scale: " + this.scale);
        }
        return p;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        int x = pt.x - this.wx + this.dUSX;
        int y = this.hy - pt.y + this.dUSY;
        return this.helper.inverse(x, y, llp);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        int tx = x - this.wx + this.dUSX;
        int ty = this.hy - y + this.dUSY;
        if (Debug.debugging("LLXYViewi")) {
            LatLonPoint tllp = this.helper.inverse(tx, ty, llp);
            Debug.output("xy: " + x + "," + y + " txty: " + tx + "," + ty + " llp: " + tllp.getLongitude() + "," + tllp.getLatitude());
        }
        return this.helper.inverse(tx, ty, llp);
    }

    private class LLXYViewHelper
    extends LLXY {
        public LLXYViewHelper(LatLonPoint center, float scale, int width, int height) {
            super(center, scale, width, height, 6303);
        }

        public void setAllParams(int hPixelsPerMeter, float hPlanetRadius, float hPlanetPixelRadius, float hPlanetPixelCircumference, float hMinscale, float hMaxscale, float hScale, float hScaled_radius, int hWidth, int hHeight, float hCtrLat, float hCtrLon) {
            this.pixelsPerMeter = hPixelsPerMeter;
            this.planetRadius = hPlanetRadius;
            this.planetPixelRadius = hPlanetPixelRadius;
            this.planetPixelCircumference = hPlanetPixelCircumference;
            this.minscale = hMinscale;
            this.maxscale = hMaxscale;
            this.scale = hScale;
            this.scaled_radius = hScaled_radius;
            this.width = hWidth;
            this.height = hHeight;
            this.ctrLat = hCtrLat;
            this.ctrLon = hCtrLon;
            this.computeParameters();
        }

        public String toString() {
            return "LLXYViewHelper[" + super.toString();
        }

        public Point forward(LatLonPoint pt, Point p) {
            super.forward(pt, p);
            if (Debug.debugging("LLXYViewHelperf")) {
                Debug.output("forward l,l,p: " + pt.getLongitude() + "," + pt.getLatitude() + " help xy: " + p.x + "," + p.y);
            }
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public Point forward(float lat, float lon, Point p) {
            super.forward(lat, lon, p);
            if (Debug.debugging("LLXYViewHelperf")) {
                Debug.output("forward l,l,p: " + lon + "," + lat + " help xy: " + p.x + "," + p.y);
            }
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public Point forward(float lat, float lon, Point p, boolean isRadian) {
            super.forward(lat, lon, p, isRadian);
            if (Debug.debugging("LLXYViewHelperf")) {
                Debug.output("forward l,l,p: " + ProjMath.radToDeg(lon) + "," + ProjMath.radToDeg(lat) + " help xy: " + p.x + "," + p.y);
            }
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public LatLonPoint inverse(Point pt, LatLonPoint llp) {
            int x = pt.x + this.wx;
            int y = this.hy - pt.y;
            if (Debug.debugging("LLXYViewHelperi")) {
                Debug.output("inverse helper x,y: " + x + "," + y);
            }
            return super.inverse(x, y, llp);
        }

        public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
            x += this.wx;
            y = this.hy - y;
            if (Debug.debugging("LLXYViewHelperi")) {
                Debug.output("inverse helper x,y: " + x + "," + y);
            }
            return super.inverse(x, y, llp);
        }
    }
}

