/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.wms;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.plugin.WebImagePlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class WMSPlugIn
extends WebImagePlugIn
implements ImageServerConstants {
    protected String wmsServer = null;
    protected String imageFormat = null;
    protected String imageQuality = "MEDIUM";
    protected String backgroundColor = null;
    protected String transparent = null;
    protected String wmsVersion = null;
    protected String layers = null;
    protected String styles = null;
    protected String vendorSpecificNames = null;
    protected String vendorSpecificValues = null;
    protected String queryHeader = null;
    protected String mapRequestName = "GetMap";
    protected String errorHandling = "application/vnd.ogc.se_inimage";
    public static final String WMSNameProperty = "wmsname";
    public static final String WMSServerProperty = "wmsserver";
    public static final String ImageFormatProperty = "format";
    public static final String BackgroundColorProperty = "backgroundcolor";
    public static final String TransparentProperty = "transparent";
    public static final String WMSVersionProperty = "wmsversion";
    public static final String LayersProperty = "layers";
    public static final String StylesProperty = "styles";
    public static final String VendorSpecificNamesProperty = "vendorspecificnames";
    public static final String VendorSpecificValuesProperty = "vendorspecificvalues";
    public static final int LOSSY_IMAGE_QUALITY_HIGH = 2;
    public static final int LOSSY_IMAGE_QUALITY_MEDIUM = 1;
    public static final int LOSSY_IMAGE_QUALITY_LOW = 0;

    public void addLayers(String[] ls) {
        this.addLayers(ls, null);
    }

    public void addLayers(String[] ls, String[] st) {
        int j = 0;
        while (j < ls.length) {
            this.layers = this.layers + "," + ls[j];
            this.styles = st == null || j >= st.length || st[j] == null ? this.styles + "," : this.styles + "," + st[j];
            ++j;
        }
    }

    public String createQueryString(Projection p) {
        if (this.queryHeader == null) {
            return null;
        }
        String bbox = "undefined";
        String height = "undefined";
        String width = "undefined";
        if (p != null) {
            bbox = Float.toString(p.getUpperLeft().getLongitude()) + "," + Float.toString(p.getLowerRight().getLatitude()) + "," + Float.toString(p.getLowerRight().getLongitude()) + "," + Float.toString(p.getUpperLeft().getLatitude());
            height = Integer.toString(p.getHeight());
            width = Integer.toString(p.getWidth());
        }
        StringBuffer buf = new StringBuffer(this.queryHeader);
        buf.append("?VERSION=" + this.wmsVersion + "&" + "REQUEST" + "=" + this.mapRequestName + "&" + "SRS" + "=" + "EPSG:4326" + "&" + "BBOX" + "=" + bbox + "&" + "HEIGHT" + "=" + height + "&" + "WIDTH" + "=" + width + "&" + "EXCEPTIONS" + "=" + this.errorHandling);
        if (this.imageFormat != null) {
            buf.append("&FORMAT=" + this.imageFormat);
            String baseImageFormat = this.imageFormat;
            if (baseImageFormat.indexOf(47) > 0) {
                baseImageFormat = baseImageFormat.substring(baseImageFormat.indexOf(47));
            }
            if (baseImageFormat.equals("JPEG")) {
                buf.append("&quality=" + this.imageQuality);
            }
        }
        if (this.transparent != null) {
            buf.append("&TRANSPARENT=" + this.transparent);
        }
        if (this.backgroundColor != null) {
            buf.append("&BGCOLOR=" + this.backgroundColor);
        }
        if (this.layers != null) {
            buf.append("&LAYERS=" + this.layers);
        }
        if (this.styles != null) {
            buf.append("&STYLES=" + this.styles);
        }
        if (Debug.debugging("wms")) {
            Debug.output("query string: " + buf);
        }
        if (this.vendorSpecificNames != null && this.vendorSpecificValues != null) {
            StringTokenizer nameTokenizer = new StringTokenizer(this.vendorSpecificNames, ",");
            StringTokenizer valueTokenizer = new StringTokenizer(this.vendorSpecificValues, ",");
            String paramName = null;
            String paramValue = null;
            while (nameTokenizer.hasMoreTokens()) {
                try {
                    paramName = nameTokenizer.nextToken();
                    paramValue = valueTokenizer.nextToken();
                    buf.append("&" + paramName + "=" + paramValue);
                }
                catch (NoSuchElementException e) {
                    if (!Debug.debugging("wms")) continue;
                    Debug.output("WMSPlugIn.getRectangle(): parameter \"" + paramName + "\" has no value");
                }
            }
        }
        return buf.toString();
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.wmsServer = setList.getProperty(prefix + WMSServerProperty);
        if (this.wmsServer == null) {
            Debug.error("WMSPlugIn needs a WMS server.");
        }
        this.queryHeader = this.wmsServer;
        this.imageFormat = setList.getProperty(prefix + ImageFormatProperty);
        this.transparent = setList.getProperty(prefix + TransparentProperty);
        this.backgroundColor = setList.getProperty(prefix + BackgroundColorProperty);
        this.wmsVersion = setList.getProperty(prefix + WMSVersionProperty);
        if (this.wmsVersion == null) {
            this.wmsVersion = "1.1.0";
            Debug.output("WMSPlugin: wmsVersion was null, now set to 1.1.0");
        }
        if (Debug.debugging("wms")) {
            Debug.output("WMSPlugIn: set up with header \"" + this.queryHeader + "\"");
        }
        StringTokenizer st = new StringTokenizer(this.wmsVersion, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        int midVersion = Integer.parseInt(st.nextToken());
        int minorVersion = Integer.parseInt(st.nextToken());
        if (majorVersion == 1 && midVersion == 0 && minorVersion < 3) {
            this.mapRequestName = "map";
        }
        if (majorVersion == 1 && minorVersion > 7) {
            this.imageFormat = "image/" + this.imageFormat;
        }
        if (majorVersion == 1 && midVersion == 0) {
            this.errorHandling = "INIMAGE";
        } else if (majorVersion == 1 && midVersion >= 1 && minorVersion > 1) {
            this.errorHandling = "application/vnd.ogc.se+inimage";
        } else if (majorVersion > 1) {
            this.errorHandling = "application/vnd.ogc.se+inimage";
        }
        this.layers = setList.getProperty(prefix + LayersProperty);
        this.styles = setList.getProperty(prefix + StylesProperty);
        this.vendorSpecificNames = setList.getProperty(prefix + VendorSpecificNamesProperty);
        this.vendorSpecificValues = setList.getProperty(prefix + VendorSpecificValuesProperty);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + WMSServerProperty, PropUtils.unnull(this.wmsServer));
        props.put(prefix + ImageFormatProperty, PropUtils.unnull(this.imageFormat));
        props.put(prefix + TransparentProperty, PropUtils.unnull(this.transparent));
        props.put(prefix + BackgroundColorProperty, PropUtils.unnull(this.backgroundColor));
        props.put(prefix + WMSVersionProperty, PropUtils.unnull(this.wmsVersion));
        props.put(prefix + LayersProperty, PropUtils.unnull(this.layers));
        props.put(prefix + StylesProperty, PropUtils.unnull(this.styles));
        props.put(prefix + VendorSpecificNamesProperty, PropUtils.unnull(this.vendorSpecificNames));
        props.put(prefix + VendorSpecificValuesProperty, PropUtils.unnull(this.vendorSpecificValues));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put("initProperties", "wmsserver wmsversion layers styles vendorspecificnames vendorspecificvalues format transparent backgroundcolor");
        props.put(WMSServerProperty, "URL to the server script that responds to WMS map requests");
        props.put(ImageFormatProperty, "Image format (GIF, PNG, JPEG)");
        props.put(TransparentProperty, "Flag to indicate that background of image should be tranparent");
        props.put("transparent.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put(BackgroundColorProperty, "The Background color for the image");
        props.put("backgroundcolor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        props.put(WMSVersionProperty, "The WMS specification version");
        props.put(LayersProperty, "A list of layers to use in the query");
        props.put(StylesProperty, "A list of layer styles to use inthe query");
        props.put(VendorSpecificNamesProperty, "Vendor-specific capability names to use in the query");
        props.put(VendorSpecificValuesProperty, "Vendor-specific capability values for the names");
        return props;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String newImageFormat) {
        String checkImageFormat = newImageFormat;
        if (newImageFormat.indexOf(47) > 0) {
            checkImageFormat = newImageFormat.substring(newImageFormat.indexOf(47));
        }
        if (checkImageFormat.equals("GIF") || checkImageFormat.equals("JPEG") || checkImageFormat.equals("PNG")) {
            this.imageFormat = newImageFormat;
        }
    }

    public void setImageQuality(int newImageQuality) {
        if (newImageQuality == 2) {
            this.imageQuality = "HIGH";
        } else if (newImageQuality == 1) {
            this.imageQuality = "MEDIUM";
        } else if (newImageQuality == 0) {
            this.imageQuality = "LOW";
        }
    }

    public String getServerName() {
        return this.wmsServer;
    }
}

