/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.awt;

import java.awt.geom.Point2D;
import java.util.LinkedList;

public class LineUtil {
    private static float FLT_EPSILON = 1.1920929E-7f;

    public static double norm2(Point2D A, Point2D B) {
        return (A.getX() - B.getX()) * (A.getX() - B.getX()) + (A.getY() - B.getY()) * (A.getY() - B.getY());
    }

    public static double norm(Point2D A, Point2D B) {
        return Math.sqrt(LineUtil.norm2(A, B));
    }

    public static Point2D interpolatedPoint(Point2D A, Point2D B, double d) {
        double r = Math.sqrt(d * d / LineUtil.norm2(A, B));
        if (r < (double)FLT_EPSILON) {
            return A;
        }
        if (1.0 - r < (double)FLT_EPSILON) {
            return B;
        }
        Point2D.Double P = new Point2D.Double(r * B.getX() + (1.0 - r) * A.getX(), r * B.getY() + (1.0 - r) * A.getY());
        return P;
    }

    protected static boolean retrievePoints(float length, LinkedList points, LinkedList polysegment) {
        polysegment.clear();
        Point2D point = (Point2D)points.removeFirst();
        polysegment.add(point);
        double consumedLength = 0.0;
        double norm = 0.0;
        Point2D nextPoint = null;
        while (consumedLength < (double)length && points.size() > 0) {
            nextPoint = (Point2D)points.removeFirst();
            polysegment.add(nextPoint);
            norm = LineUtil.norm(point, nextPoint);
            consumedLength += norm;
            point = nextPoint;
        }
        if (consumedLength == (double)length) {
            points.addFirst(point);
            return true;
        }
        if (consumedLength > (double)length) {
            points.addFirst(polysegment.removeLast());
            point = (Point2D)polysegment.getLast();
            double d = (double)length - (consumedLength -= norm);
            Point2D interp = LineUtil.interpolatedPoint(point, nextPoint, d);
            polysegment.add(interp);
            points.addFirst(interp);
            return true;
        }
        return false;
    }
}

