/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.ListStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EditableOMGraphicList
extends EditableOMGraphic {
    protected OffsetGrabPoint gpm;
    protected OMGraphicList list;
    protected List editables;

    public EditableOMGraphicList() {
        this(new OMGraphicList());
    }

    public EditableOMGraphicList(OMGraphicList oml) {
        this.setGraphic(oml);
    }

    public List getEditables() {
        if (this.editables == null) {
            this.editables = new LinkedList();
        }
        return this.editables;
    }

    public void init() {
        Debug.message("eomg", "EditableOMGraphicList.init()");
        this.getEditables();
        this.setStateMachine(new ListStateMachine(this));
    }

    public void init(OMDrawingTool drawingTool) {
        if (this.list != null) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                OMGraphic omg = (OMGraphic)it.next();
                if (!omg.isVisible()) continue;
                this.add(omg, drawingTool);
            }
        }
    }

    public GrabPoint[] getGrabPoints() {
        return new GrabPoint[]{this.gpm};
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMGraphicList) {
            this.list = (OMGraphicList)graphic;
            this.list.setProcessAllGeometries(true);
            this.stateMachine.setSelected();
            this.gpm = new OffsetGrabPoint(-10, -10);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        OMGraphicList tmpList = new OMGraphicList();
        if (ga != null) {
            ga.setTo(tmpList);
        }
        this.setGraphic(tmpList);
    }

    public OMGraphic getGraphic() {
        return this.list;
    }

    public void add(OMGraphicList list, OMDrawingTool drawingTool) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.add((OMGraphic)it.next(), drawingTool);
        }
    }

    public EditableOMGraphic add(OMGraphic omg, OMDrawingTool drawingTool) {
        EditableOMGraphic editable = null;
        if (omg instanceof OMGraphicList) {
            this.add((OMGraphicList)omg, drawingTool);
            return editable;
        }
        if (omg != null && drawingTool != null) {
            editable = drawingTool.getEditableGraphic(omg);
            if (editable != null) {
                this.add(editable);
            } else if (Debug.debugging("eomg")) {
                Debug.output("EditableOMGraphicList can't handle " + omg.getClass().getName());
            }
        } else if (Debug.debugging("eomg")) {
            Debug.output("EditableOMGraphicList told to add null OMGraphic or null OMDrawingTool");
        }
        return editable;
    }

    public void add(EditableOMGraphic editable) {
        OMGraphic graphic;
        if (editable == null) {
            if (Debug.debugging("eomg")) {
                Debug.output("EditableOMGraphicList adding null EditableOMGraphic");
            }
            return;
        }
        if (Debug.debugging("eomg")) {
            Debug.output("EditableOMGraphicList adding " + editable.getClass().getName() + " " + editable);
        }
        if (!this.list.contains(graphic = editable.getGraphic())) {
            this.getEditables().add(editable);
            editable.setProjection(this.getProjection());
            this.list.add(graphic);
            editable.attachToMovingGrabPoint(this.gpm);
        } else if (Debug.debugging("eomg")) {
            Debug.output("EditableOMGraphicList.add(" + editable.getClass().getName() + ") not added, duplicate");
        }
    }

    public void remove(OMGraphic omg) {
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            EditableOMGraphic eomg = (EditableOMGraphic)it.next();
            if (eomg.getGraphic() != omg) continue;
            this.remove(eomg);
            this.list.remove(omg);
        }
    }

    public boolean remove(EditableOMGraphic editable) {
        if (editable == null) {
            if (Debug.debugging("eomg")) {
                Debug.output("EditableOMGraphicList removing null EditableOMGraphic");
            }
            return false;
        }
        if (Debug.debugging("eomg")) {
            Debug.output("EditableOMGraphicList removing " + editable.getClass().getName());
        }
        editable.setProjection(null);
        editable.detachFromMovingGrabPoint(this.gpm);
        boolean ret = this.getEditables().remove(editable);
        return ret;
    }

    public void clear() {
        this.getEditables().clear();
        this.gpm.clear();
    }

    public void setProjection(Projection proj) {
        if (Debug.debugging("eomg")) {
            Debug.output("EOMGL: setProjection(" + proj + ")");
        }
        super.setProjection(proj);
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            ((EditableOMGraphic)it.next()).setProjection(proj);
        }
    }

    public void setGrabPoints() {
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            EditableOMGraphic editable = (EditableOMGraphic)it.next();
            editable.setGrabPoints();
        }
    }

    public GrabPoint getMovingPoint(MouseEvent me) {
        if (this.list != null) {
            float distance = this.list.distance(me.getX(), me.getY());
            if (distance <= 4.0f) {
                this.move(me);
            } else {
                this.movingPoint = null;
            }
        } else {
            this.movingPoint = null;
        }
        return this.movingPoint;
    }

    public void move(MouseEvent e) {
        if (this.gpm != null) {
            this.gpm.set(e.getX(), e.getY());
            this.gpm.updateOffsets();
            this.movingPoint = this.gpm;
        }
    }

    public boolean generate(Projection proj) {
        Debug.message("eomg", "EditableOMGraphicList.generate()");
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            ((EditableOMGraphic)it.next()).generate(proj);
        }
        if (this.gpm != null) {
            this.gpm.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMGraphicList.regenerate()");
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            ((EditableOMGraphic)it.next()).regenerate(proj);
        }
        if (this.gpm != null) {
            this.gpm.generate(proj);
        }
    }

    public void render(Graphics graphics) {
        Iterator it = this.getEditables().iterator();
        while (it.hasNext()) {
            ((EditableOMGraphic)it.next()).render(graphics);
        }
    }
}

