/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.NumAndBox;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionListener;
import java.io.IOException;

public class ShapeLayer2
extends ShapeLayer
implements ActionListener {
    public ShapeLayer2() {
    }

    public ShapeLayer2(String shapeFileName) {
        super(shapeFileName);
    }

    protected OMGeometryList RecordList(ESRIRecord rec) {
        return this.RecordList(null, rec);
    }

    protected OMGeometryList RecordList(OMGeometryList list, ESRIRecord rec) {
        if (list == null) {
            list = new OMGeometryList(10);
        }
        OMGeometry geom = rec.addOMGeometry(list);
        geom.setAppObject(new NumAndBox(rec.getRecordNumber(), rec.getBoundingBox()));
        return list;
    }

    public OMGraphicList prepare() {
        if (this.spatialIndex == null) {
            Debug.message("shape", "ShapeLayer: spatialIndex is null!");
            return new OMGraphicList();
        }
        Projection projection = this.getProjection();
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        OMGeometryList stuff = new OMGeometryList();
        this.drawingAttributes.setTo(stuff);
        if (ulLon > lrLon || MoreMath.approximately_equal(ulLon, lrLon, 0.001f)) {
            if (Debug.debugging("shape")) {
                Debug.output("ShapeLayer.computeGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                ESRIRecord[] records1 = this.spatialIndex.locateRecords(ulLon, ymin, 180.0, ymax);
                ESRIRecord[] records2 = this.spatialIndex.locateRecords(-180.0, ymin, lrLon, ymax);
                int nRecords1 = records1.length;
                int nRecords2 = records2.length;
                int i = 0;
                while (i < nRecords1) {
                    this.RecordList(stuff, records1[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < nRecords2) {
                    this.RecordList(stuff, records2[i2]);
                    ++i2;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
                int nRecords = records.length;
                int i = 0;
                while (i < nRecords) {
                    this.RecordList(stuff, records[i]);
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        }
        if (stuff != null) {
            stuff.generate(projection, true);
        }
        return stuff;
    }
}

