/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfCoverageManager;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RpfCoverage
implements ActionListener,
RpfConstants,
PropertyConsumer {
    protected Vector omGraphics;
    protected boolean cancelled = false;
    protected RpfCoverageManager coverageManager = null;
    protected String propertyPrefix = null;
    protected boolean showCG = true;
    protected boolean showTLM = true;
    protected boolean showJOG = true;
    protected boolean showTPC = true;
    protected boolean showONC = true;
    protected boolean showJNC = true;
    protected boolean showGNC = true;
    protected boolean showCIB10 = true;
    protected boolean showCIB5 = true;
    protected boolean showMISC = true;
    public static final int defaultCGColorInt = 11290707;
    public static final int defaultTLMColorInt = 13520703;
    public static final int defaultJOGColorInt = 11304308;
    public static final int defaultTPCColorInt = 11324688;
    public static final int defaultONCColorInt = 16567781;
    public static final int defaultJNCColorInt = 7571173;
    public static final int defaultGNCColorInt = 5604971;
    public static final int defaultCIB10ColorInt = 479595;
    public static final int defaultCIB5ColorInt = 466144;
    public static final int defaultMISCColorInt = 15911201;
    protected Color CGColor = new Color(11290707);
    protected Color TLMColor = new Color(13520703);
    protected Color JOGColor = new Color(11304308);
    protected Color TPCColor = new Color(11324688);
    protected Color ONCColor = new Color(16567781);
    protected Color JNCColor = new Color(7571173);
    protected Color GNCColor = new Color(5604971);
    protected Color CIB10Color = new Color(479595);
    protected Color CIB5Color = new Color(466144);
    protected Color MISCColor = new Color(15911201);
    protected int opaqueness = 255;
    protected boolean fillRects;
    public static final String CoverageOpaquenessProperty = "coverageOpaque";
    public static final String FillProperty = "coverageFill";
    protected Layer layer;
    protected boolean inUse = false;
    protected boolean showPalette = true;
    protected I18n i18n = Environment.getI18n();
    protected Color[] colors = null;
    protected JFrame paletteWindow = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$rpf$RpfLayer;

    public RpfCoverage(Layer l) {
        this.layer = l;
    }

    protected void setDefaultValues() {
        this.allCoveragesOn();
        this.opaqueness = 255;
        this.fillRects = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean iu) {
        this.inUse = iu;
        if (this.showPalette || !this.inUse) {
            this.getPaletteWindow().setVisible(this.inUse);
        }
    }

    public boolean isShowPalette() {
        return this.showPalette;
    }

    public void setShowPalette(boolean sp) {
        this.showPalette = sp;
        if (!this.showPalette) {
            this.allCoveragesOn();
        }
    }

    public void allCoveragesOn() {
        this.showCG = true;
        this.showTLM = true;
        this.showJOG = true;
        this.showTPC = true;
        this.showONC = true;
        this.showJNC = true;
        this.showGNC = true;
        this.showCIB10 = true;
        this.showCIB5 = true;
        this.showMISC = true;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties properties) {
        this.setPropertyPrefix(prefix);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fillRects = PropUtils.booleanFromProperties(properties, prefix + FillProperty, this.fillRects);
        this.showPalette = PropUtils.booleanFromProperties(properties, prefix + "coverage", this.showPalette);
        this.opaqueness = PropUtils.intFromProperties(properties, prefix + CoverageOpaquenessProperty, this.opaqueness);
        this.CGColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "CG.color", this.CGColor);
        this.TLMColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "TLM.color", this.TLMColor);
        this.JOGColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "JOG.color", this.JOGColor);
        this.TPCColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "TPC.color", this.TPCColor);
        this.ONCColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "ONC.color", this.ONCColor);
        this.JNCColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "JNC.color", this.JNCColor);
        this.GNCColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "GNC.color", this.GNCColor);
        this.CIB10Color = (Color)PropUtils.parseColorFromProperties(properties, prefix + "CIB10.color", this.CIB10Color);
        this.CIB5Color = (Color)PropUtils.parseColorFromProperties(properties, prefix + "CIB5.color", this.CIB5Color);
        this.MISCColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + "MISC.color", this.MISCColor);
        if (this.showPalette) {
            this.showCG = PropUtils.booleanFromProperties(properties, prefix + "CG.showcov", this.showCG);
            this.showTLM = PropUtils.booleanFromProperties(properties, prefix + "TLM.showcov", this.showTLM);
            this.showJOG = PropUtils.booleanFromProperties(properties, prefix + "JOG.showcov", this.showJOG);
            this.showTPC = PropUtils.booleanFromProperties(properties, prefix + "TPC.showcov", this.showTPC);
            this.showONC = PropUtils.booleanFromProperties(properties, prefix + "ONC.showcov", this.showONC);
            this.showJNC = PropUtils.booleanFromProperties(properties, prefix + "JNC.showcov", this.showJNC);
            this.showGNC = PropUtils.booleanFromProperties(properties, prefix + "GNC.showcov", this.showGNC);
            this.showCIB10 = PropUtils.booleanFromProperties(properties, prefix + "CIB10.showcov", this.showCIB10);
            this.showCIB5 = PropUtils.booleanFromProperties(properties, prefix + "CIB5.showcov", this.showCIB5);
            this.showMISC = PropUtils.booleanFromProperties(properties, prefix + "MISC.showcov", this.showMISC);
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + FillProperty, new Boolean(this.fillRects).toString());
        props.put(prefix + "coverage", new Boolean(this.showPalette).toString());
        props.put(prefix + CoverageOpaquenessProperty, Integer.toString(this.opaqueness));
        props.put(prefix + "CG.color", Integer.toHexString(this.CGColor.getRGB()));
        props.put(prefix + "TLM.color", Integer.toHexString(this.TLMColor.getRGB()));
        props.put(prefix + "JOG.color", Integer.toHexString(this.JOGColor.getRGB()));
        props.put(prefix + "TPC.color", Integer.toHexString(this.TPCColor.getRGB()));
        props.put(prefix + "ONC.color", Integer.toHexString(this.ONCColor.getRGB()));
        props.put(prefix + "JNC.color", Integer.toHexString(this.JNCColor.getRGB()));
        props.put(prefix + "GNC.color", Integer.toHexString(this.GNCColor.getRGB()));
        props.put(prefix + "CIB10.color", Integer.toHexString(this.CIB10Color.getRGB()));
        props.put(prefix + "CIB5.color", Integer.toHexString(this.CIB5Color.getRGB()));
        props.put(prefix + "MISC.color", Integer.toHexString(this.MISCColor.getRGB()));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        String interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, FillProperty, 3, "Flag to set if the coverage rectangles should be filled.");
        list.put(FillProperty, interString);
        list.put("coverageFill.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, FillProperty, "Fill Coverage Rectangles");
        list.put("coverageFill.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "coverage", 3, "Flag to set the coverage palette should be shown.");
        list.put("coverage", interString);
        list.put("coverage.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "coverage", "Show Coverage Palette");
        list.put("coverage.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, CoverageOpaquenessProperty, 3, "Integer representing opaqueness level (0-255, 0 is clear) of coverage rectangles.");
        list.put(CoverageOpaquenessProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, CoverageOpaquenessProperty, "Coverage Opaqueness");
        list.put("coverageOpaque.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CG.color", 3, "Color for City Graphics chart coverage.");
        list.put("CG.color", interString);
        list.put("CG.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CG.color", "CG Coverage Color");
        list.put("CG.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "TLM.color", 3, "Color for TLM chart coverage.");
        list.put("TLM.color", interString);
        list.put("TLM.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "TLM.color", "TLM Coverage Color");
        list.put("TLM.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "JOG.color", 3, "Color for JOG chart coverage.");
        list.put("JOG.color", interString);
        list.put("JOG.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "JOG.color", "JOG Coverage Color");
        list.put("JOG.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "TPC.color", 3, "Color for TPC chart coverage.");
        list.put("TPC.color", interString);
        list.put("TPC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "TPC.color", "TPC Coverage Color");
        list.put("TPC.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "ONC.color", 3, "Color for ONC chart coverage.");
        list.put("ONC.color", interString);
        list.put("ONC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "ONC.color", "ONC Coverage Color");
        list.put("ONC.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "JNC.color", 3, "Color for JNC chart coverage.");
        list.put("JNC.color", interString);
        list.put("JNC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "JNC.color", "JNC Coverage Color");
        list.put("JNC.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "GNC.color", 3, "Color for GNC chart coverage.");
        list.put("GNC.color", interString);
        list.put("GNC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "GNC.color", "GNC Coverage Color");
        list.put("GNC.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CIB10.color", 3, "Color for CIB 10 meter image coverage.");
        list.put("CIB10.color", interString);
        list.put("CIB10.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CIB10.color", "CIB10 Coverage Color");
        list.put("CIB10.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CIB5.color", 3, "Color for CIB 5 meter image coverage.");
        list.put("CIB5.color", interString);
        list.put("CIB5.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "CIB5.color", "CIB5 Coverage Color");
        list.put("CIB5.color.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "MISC.color", 3, "Color for all other chart/image coverage.");
        list.put("MISC.color", interString);
        list.put("MISC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$rpf$RpfLayer == null ? (class$com$bbn$openmap$layer$rpf$RpfLayer = RpfCoverage.class$("com.bbn.openmap.layer.rpf.RpfLayer")) : class$com$bbn$openmap$layer$rpf$RpfLayer, "MISC.color", "Misc Coverage Color");
        list.put("MISC.color.label", interString);
        return list;
    }

    public String getInitPropertiesOrder() {
        return " coverageFill coverageOpaque GNC.color JNC.color ONC.color TPC.color JOG.color TLM.color CIB10.color CIB5.color MISC.color";
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void prepare(RpfFrameProvider frameProvider, Projection projection, String chartSeries) {
        float ullat = 90.0f;
        float ullon = -180.0f;
        float lrlat = -90.0f;
        float lrlon = 180.0f;
        if (projection != null) {
            ullat = projection.getUpperLeft().getLatitude();
            ullon = projection.getUpperLeft().getLongitude();
            lrlat = projection.getLowerRight().getLatitude();
            lrlon = projection.getLowerRight().getLongitude();
        }
        Debug.message("basic", "RpfCoverage.prepare(): doing it");
        if (this.coverageManager == null) {
            this.coverageManager = new RpfCoverageManager(frameProvider);
        }
        this.setGraphicLists(this.coverageManager.getCatalogCoverage(ullat, ullon, lrlat, lrlon, projection, chartSeries, this.getColors(), this.fillRects));
    }

    protected void resetColors() {
        this.colors = null;
    }

    protected Color[] getColors() {
        if (this.colors == null) {
            this.colors = new Color[]{this.getModifiedColor(this.CGColor), this.getModifiedColor(this.TLMColor), this.getModifiedColor(this.JOGColor), this.getModifiedColor(this.TPCColor), this.getModifiedColor(this.ONCColor), this.getModifiedColor(this.JNCColor), this.getModifiedColor(this.GNCColor), this.getModifiedColor(this.CIB10Color), this.getModifiedColor(this.CIB5Color), this.getModifiedColor(this.MISCColor)};
        }
        return this.colors;
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(int opaqueness) {
        this.opaqueness = opaqueness;
        this.resetColors();
    }

    protected Color getModifiedColor(Color color) {
        if (this.opaqueness < 255) {
            int opa = this.opaqueness << 24;
            return ColorFactory.createColor(color.getRGB() & 0xFFFFFF | opa, true);
        }
        return ColorFactory.createColor(color.getRGB(), true);
    }

    public synchronized void setGraphicLists(Vector lists) {
        this.omGraphics = lists;
    }

    public synchronized Vector getGraphicLists() {
        return this.omGraphics;
    }

    public void paint(Graphics g) {
        Debug.message("rpfcov", "RpfCoverage.paint()");
        Vector tmpGraphics = this.getGraphicLists();
        if (tmpGraphics != null) {
            int length = tmpGraphics.size();
            Debug.message("rpfcov", "RpfCoverage.painting(): " + length + " lists");
            int k = length - 1;
            while (k >= 0) {
                if (k == 0 && this.showCG) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 1 && this.showCIB5) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 2 && this.showTLM) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 3 && this.showCIB10) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 4 && this.showJOG) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 5 && this.showMISC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 6 && this.showTPC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 7 && this.showONC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 8 && this.showJNC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 9 && this.showGNC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                --k;
            }
        } else {
            Debug.message("rpfcov", "RpfCoverage.paint(): null graphics list");
        }
    }

    public void generate(Projection proj) {
        Debug.message("rpfcov", "RpfCoverage.generate()");
        Vector tmpGraphics = this.getGraphicLists();
        if (tmpGraphics != null) {
            int length = tmpGraphics.size();
            int k = length - 1;
            while (k >= 0) {
                if (k == 0) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 1) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 2) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 3) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 4) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 5) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 6) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 7) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 8) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 9) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                --k;
            }
        }
    }

    public Component getGUI() {
        JCheckBox showCGCheck = new JCheckBox("Show City Graphic Coverage", this.showCG);
        showCGCheck.setActionCommand("showCG");
        showCGCheck.addActionListener(this);
        showCGCheck.setForeground(this.CGColor);
        JCheckBox showTLMCheck = new JCheckBox("Show TLM (1:50k) Coverage", this.showTLM);
        showTLMCheck.setActionCommand("showTLM");
        showTLMCheck.addActionListener(this);
        showTLMCheck.setForeground(this.TLMColor);
        JCheckBox showJOGCheck = new JCheckBox("Show JOG (1:250k) Coverage", this.showJOG);
        showJOGCheck.setActionCommand("showJOG");
        showJOGCheck.addActionListener(this);
        showJOGCheck.setForeground(this.JOGColor);
        JCheckBox showTPCCheck = new JCheckBox("Show TPC (1:500k) Coverage", this.showTPC);
        showTPCCheck.setActionCommand("showTPC");
        showTPCCheck.addActionListener(this);
        showTPCCheck.setForeground(this.TPCColor);
        JCheckBox showONCCheck = new JCheckBox("Show ONC (1:1M) Coverage", this.showONC);
        showONCCheck.setActionCommand("showONC");
        showONCCheck.addActionListener(this);
        showONCCheck.setForeground(this.ONCColor);
        JCheckBox showJNCCheck = new JCheckBox("Show JNC (1:2M) Coverage", this.showJNC);
        showJNCCheck.setActionCommand("showJNC");
        showJNCCheck.addActionListener(this);
        showJNCCheck.setForeground(this.JNCColor);
        JCheckBox showGNCCheck = new JCheckBox("Show GNC (1:5M) Coverage", this.showGNC);
        showGNCCheck.setActionCommand("showGNC");
        showGNCCheck.addActionListener(this);
        showGNCCheck.setForeground(this.GNCColor);
        JCheckBox showCIB10Check = new JCheckBox("Show CIB 10m Coverage", this.showCIB10);
        showCIB10Check.setActionCommand("showCIB10");
        showCIB10Check.addActionListener(this);
        showCIB10Check.setForeground(this.CIB10Color);
        JCheckBox showCIB5Check = new JCheckBox("Show CIB 5m Coverage", this.showCIB5);
        showCIB5Check.setActionCommand("showCIB5");
        showCIB5Check.addActionListener(this);
        showCIB5Check.setForeground(this.CIB5Color);
        JCheckBox showMISCCheck = new JCheckBox("Show Coverage of all Others", this.showMISC);
        showMISCCheck.setActionCommand("showMISC");
        showMISCCheck.addActionListener(this);
        showMISCCheck.setForeground(this.MISCColor);
        Box box = Box.createVerticalBox();
        box.add(showCGCheck);
        box.add(showTLMCheck);
        box.add(showJOGCheck);
        box.add(showTPCCheck);
        box.add(showONCCheck);
        box.add(showJNCCheck);
        box.add(showGNCCheck);
        box.add(showCIB10Check);
        box.add(showCIB5Check);
        box.add(showMISCCheck);
        return box;
    }

    public JFrame getPaletteWindow() {
        if (this.paletteWindow == null) {
            Component pal = this.getGUI();
            if (pal == null) {
                pal = new JLabel("No Palette");
            }
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setAlignmentX(0.0f);
            p.setAlignmentY(1.0f);
            p.add(pal);
            JScrollPane scrollPane = new JScrollPane(p, 20, 30);
            scrollPane.setAlignmentX(0.0f);
            scrollPane.setAlignmentY(0.0f);
            this.paletteWindow = new JFrame("RPF Coverage Palette");
            this.paletteWindow.setContentPane(scrollPane);
            this.paletteWindow.pack();
        }
        return this.paletteWindow;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        JCheckBox check = (JCheckBox)e.getSource();
        if (cmd == "showCG") {
            this.showCG = check.isSelected();
        } else if (cmd == "showTLM") {
            this.showTLM = check.isSelected();
        } else if (cmd == "showJOG") {
            this.showJOG = check.isSelected();
        } else if (cmd == "showTPC") {
            this.showTPC = check.isSelected();
        } else if (cmd == "showONC") {
            this.showONC = check.isSelected();
        } else if (cmd == "showJNC") {
            this.showJNC = check.isSelected();
        } else if (cmd == "showGNC") {
            this.showGNC = check.isSelected();
        } else if (cmd == "showCIB10") {
            this.showCIB10 = check.isSelected();
        } else if (cmd == "showCIB5") {
            this.showCIB5 = check.isSelected();
        } else if (cmd == "showMISC") {
            this.showMISC = check.isSelected();
        } else {
            System.err.println("Unknown action command \"" + cmd + "\" in RpfCoverageLayer.actionPerformed().");
        }
        this.layer.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

