/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class LinkProperties
extends Properties
implements LinkPropertiesConstants,
LinkGraphicConstants {
    public static final LinkProperties EMPTY_PROPERTIES = new LinkProperties();

    public LinkProperties() {
    }

    public LinkProperties(String keyString, String valueString) {
        this.setProperty(keyString, valueString);
    }

    public LinkProperties(Link link) throws IOException {
        this.read(link.dis);
    }

    public LinkProperties(DataInput dis) throws IOException {
        this.read(dis);
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void write(Link link) throws IOException {
        this.write(link.dos);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size() * 2);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            dos.writeInt(key.length());
            dos.writeChars(key);
            dos.writeInt(value.length());
            dos.writeChars(value);
        }
    }

    public void read(DataInput dis) throws IOException {
        int numArgs = dis.readInt();
        String[] argStrings = new String[numArgs];
        int i = 0;
        while (i < numArgs) {
            int argLength = dis.readInt();
            argStrings[i] = LinkUtil.readString(dis, argLength);
            argLength = dis.readInt();
            argStrings[i + 1] = LinkUtil.readString(dis, argLength);
            this.put(argStrings[i], argStrings[i + 1]);
            i += 2;
        }
        if (Debug.debugging("linkdetail")) {
            System.out.println("LinkProperties | Read:  " + this);
        }
    }

    public void setProperties(OMGraphic omg) {
        if (omg == null) {
            return;
        }
        omg.setLinePaint(this.getPaint("lineColor", "FF000000"));
        omg.setFillPaint(this.getFillPaint());
        omg.setSelectPaint(this.getPaint("highlightColor", "FF000000"));
        omg.setStroke(this.getStroke());
        omg.setAppObject(this);
    }

    public Stroke getStroke() {
        int lineWidth = PropUtils.intFromProperties(this, "lineWidth", 1);
        int cap = 2;
        int join = 0;
        float miterLimit = 10.0f;
        float dashPhase = 0.0f;
        String strokeString = this.getProperty("lineStyle");
        BasicStroke stroke = null;
        float[] dash = null;
        if (strokeString != null) {
            if (strokeString.equalsIgnoreCase("LONG_DASH")) {
                dash = new float[]{10.0f, 10.0f};
            } else if (strokeString.equalsIgnoreCase("DASH")) {
                dash = new float[]{6.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("DOT")) {
                dash = new float[]{3.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("DASH_DOT")) {
                dash = new float[]{6.0f, 6.0f, 3.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("DASH_DOT_DOT")) {
                dash = new float[]{6.0f, 6.0f, 3.0f, 6.0f, 3.0f, 6.0f};
            }
            if (dash != null) {
                stroke = new BasicStroke(lineWidth, cap, join, miterLimit, dash, dashPhase);
            }
        }
        if (stroke == null) {
            stroke = new BasicStroke(lineWidth);
        }
        return stroke;
    }

    public Paint getPaint(String paintProperty, String defaultPaintString) {
        return ColorFactory.parseColorFromProperties(this, paintProperty, defaultPaintString, true);
    }

    public Paint getFillPaint() {
        Paint fillPaint = this.getPaint("fillColor", "00000000");
        String pattern = this.getProperty("fillPattern");
        if (pattern == null || pattern.equalsIgnoreCase("SOLID")) {
            return fillPaint;
        }
        BufferedImage bi = new BufferedImage(8, 8, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(new Color(0, true));
        big.fillRect(0, 0, 8, 8);
        big.setPaint(fillPaint);
        if (pattern.equalsIgnoreCase("HORIZONTAL")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 4.0, 7.0, 4.0));
        } else if (pattern.equalsIgnoreCase("VERTICAL")) {
            big.draw(new Line2D.Double(0.0, 0.0, 0.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 4.0, 7.0));
        } else if (pattern.equalsIgnoreCase("CROSS")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 4.0, 7.0, 4.0));
            big.draw(new Line2D.Double(0.0, 0.0, 0.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 4.0, 7.0));
        } else if (pattern.equalsIgnoreCase("DIAG_CROSS")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 7.0));
            big.draw(new Line2D.Double(0.0, 4.0, 3.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 7.0, 3.0));
            big.draw(new Line2D.Double(0.0, 7.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 3.0, 3.0, 0.0));
            big.draw(new Line2D.Double(4.0, 7.0, 7.0, 4.0));
        } else if (pattern.equalsIgnoreCase("BACKWARD_DIAG")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 7.0));
            big.draw(new Line2D.Double(0.0, 4.0, 3.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 7.0, 3.0));
        } else if (pattern.equalsIgnoreCase("FORWARD_DIAG")) {
            big.draw(new Line2D.Double(0.0, 7.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 3.0, 3.0, 0.0));
            big.draw(new Line2D.Double(4.0, 7.0, 7.0, 4.0));
        } else {
            big.fillRect(0, 0, 8, 8);
        }
        Rectangle r = new Rectangle(0, 0, 8, 8);
        return new TexturePaint(bi, r);
    }
}

