/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.util.Debug;
import java.awt.Color;

public class DTEDFrameColorTable {
    public static final int DTED_COLORS = 216;
    public static final int NUM_ELEVATION_COLORS = 16;
    public static final int DEFAULT_OPAQUENESS = 255;
    public Color[] colors;
    protected Color[] ccolors = null;
    protected Color[] gcolors = null;
    protected int opaqueness = 255;
    protected boolean greyScale = true;
    public int adjustment = 3;
    int[] elevation_color_cutoff = new int[]{0, 50, 100, 200, 400, 800, 1200, 1600, 2000, 3000, 4000, 6000, 8000, 10000, 12000, 33000};
    int[] reds = new int[]{191, 20, 40, 60, 110, 140, 190, 225, 179, 159, 163, 178, 185, 215, 217, 243};
    int[] greens = new int[]{239, 95, 102, 128, 153, 175, 200, 200, 158, 142, 152, 165, 165, 205, 217, 243};
    int[] blues = new int[]{250, 70, 80, 100, 130, 150, 150, 155, 77, 51, 51, 77, 112, 140, 217, 230};

    public DTEDFrameColorTable() {
        this(216, 255, true);
    }

    public DTEDFrameColorTable(int num_colors) {
        this(num_colors, 255, true);
    }

    public DTEDFrameColorTable(int num_colors, int opaque, boolean greyscale) {
        this.opaqueness = opaque;
        this.ccolors = this.createColors(num_colors, this.adjustment);
        this.gcolors = this.createGreyScaleColors(num_colors);
        this.greyScale = greyscale;
        this.colors = this.greyScale ? this.gcolors : this.ccolors;
    }

    public DTEDFrameColorTable(DTEDFrameColorTable cTable) {
        this.opaqueness = cTable.getOpaqueness();
        this.ccolors = cTable.getCColors();
        this.gcolors = cTable.getGColors();
        this.setGreyScale(cTable.getGreyScale());
        int i = 0;
        while (i < cTable.colors.length) {
            this.colors[i] = cTable.colors[i];
            ++i;
        }
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(int opaque) {
        Color tc;
        int i;
        this.opaqueness = opaque;
        if (this.ccolors != null) {
            i = 0;
            while (i < this.ccolors.length) {
                tc = this.ccolors[i];
                this.ccolors[i] = new Color(tc.getRed(), tc.getGreen(), tc.getBlue(), this.opaqueness);
                ++i;
            }
        }
        if (this.gcolors != null) {
            i = 0;
            while (i < this.gcolors.length) {
                tc = this.gcolors[i];
                this.gcolors[i] = new Color(tc.getRed(), tc.getGreen(), tc.getBlue(), this.opaqueness);
                ++i;
            }
        }
    }

    public Color[] getCColors() {
        return this.ccolors;
    }

    public Color[] getGColors() {
        return this.gcolors;
    }

    public void setGreyScale(boolean greyscale) {
        this.greyScale = greyscale;
        this.colors = this.greyScale ? this.gcolors : this.ccolors;
    }

    public boolean getGreyScale() {
        return this.greyScale;
    }

    public int numColors() {
        return this.colors.length;
    }

    public int colorValue(int color_index) {
        if (color_index > 0 && color_index < this.colors.length) {
            return this.colors[color_index].getRGB();
        }
        return -1;
    }

    protected Color[] createGreyScaleColors(int num_colors) {
        if (num_colors == 0) {
            num_colors = 216;
        }
        Color[] tempColors = new Color[num_colors];
        int grey_interval = 256 / num_colors;
        int i = 0;
        while (i < num_colors) {
            if (i == 0) {
                tempColors[i] = new Color(191, 239, 255, 0);
            } else {
                int color = i * grey_interval + grey_interval / 2;
                tempColors[i] = new Color(color, color, color, this.opaqueness);
            }
            ++i;
        }
        return tempColors;
    }

    protected Color[] createColors(int num_colors, int adjustment) {
        if (num_colors == 0) {
            num_colors = 216;
        }
        Color[] tempColors = new Color[num_colors];
        int ncolors = 16;
        int num_loops = 1;
        int modifier = (5 - adjustment) * 4;
        if (num_colors >= 48) {
            ncolors = 48;
            num_loops = 3;
        } else if (num_colors >= 32) {
            ncolors = 32;
            num_loops = 2;
        }
        tempColors = new Color[ncolors];
        if (Debug.debugging("dteddetail")) {
            Debug.output("DTEDFrameColortable: Setting number of colors to " + ncolors);
        }
        int j = 0;
        while (j < num_loops) {
            if (Debug.debugging("dteddetail")) {
                Debug.output("dted_raster: Setting round " + j + " of colors.");
            }
            tempColors[16 * j] = new Color(191, 239, 255, 0);
            int i = 1;
            while (i < 16) {
                switch (j) {
                    case 0: {
                        int red = this.reds[i] - (20 - modifier) / 2;
                        int green = this.greens[i] - (20 - modifier) / 2;
                        int blue = this.blues[i] - (20 - modifier) / 2;
                        tempColors[i] = new Color(red, green, blue, this.opaqueness);
                        break;
                    }
                    case 1: {
                        int red = this.reds[i] - (20 - modifier);
                        int green = this.greens[i] - (20 - modifier);
                        int blue = this.blues[i] - (20 - modifier);
                        tempColors[i + 16] = new Color(red, green, blue, this.opaqueness);
                        break;
                    }
                    case 2: {
                        int red = this.reds[i];
                        int green = this.greens[i];
                        int blue = this.blues[i];
                        tempColors[i + 32] = new Color(red, green, blue, this.opaqueness);
                        break;
                    }
                }
                ++i;
            }
            ++j;
        }
        return tempColors;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            System.out.println("DTEDFrameColorTable:  Need a number.");
            System.exit(0);
        }
        System.out.println("DTEDFrameColorTable: " + args[0]);
        int nColors = new Integer(args[0]);
        DTEDFrameColorTable ct = new DTEDFrameColorTable(nColors);
        System.out.println(ct);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("DTEDFrameColortable: \n");
        int i = 0;
        while (i < this.colors.length) {
            s.append("OMColor " + i + ": alpha = " + this.colors[i].getAlpha());
            s.append(", red = " + this.colors[i].getRed());
            s.append(", green = " + this.colors[i].getGreen());
            s.append(", blue = " + this.colors[i].getBlue() + "\n");
            ++i;
        }
        return s.toString();
    }
}

