/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.daynight;

import com.bbn.openmap.LatLonPoint;
import java.util.Date;
import java.util.GregorianCalendar;

public class SunPosition {
    public static final double EPOCH_JULIAN_DATE = 2447891.5;
    public static final double EPOCH_TIME_SECS = 6.310656E8;
    public static double ORBIT_RADS_PER_DAY = 0.017202792111235436;
    public static final double ECLIPTIC_LONGITUDE_EPOCH = 4.87650757893409;
    public static final double epsilon_g = 4.87650757893409;
    public static final double ECLIPTIC_LONGITUDE_PERIGEE = 4.935239985213178;
    public static final double omega_bar_g = 4.935239985213178;
    public static final double ECCENTRICITY = 0.016713;
    public static final double MEAN_OBLIQUITY_OF_EPOCH = 0.4091155;
    public static final double MOON_EPOCH_MEAN_LONGITUDE = 5.556284436750021;
    public static final double el0 = 5.556284436750021;
    public static final double PERIGEE_EPOCH_MEAN_LONGITUDE = 0.6342598060246725;
    public static final double P0 = 0.6342598060246725;
    public static final double NODE_EPOCH_MEAN_LONGITUDE = 5.559050068029439;
    public static final double N0 = 5.559050068029439;
    public static final double MOON_ORBIT_INCLINATION = 0.08980410151894615;
    public static final double eye = 0.08980410151894615;
    public static final double MOON_ECCENTRICITY = 0.0549;
    public static final double MAJOR_AXIS_MOON_ORBIT = 384401.0;
    public static final double MOON_ANGULAR_SIZE = 0.009042550854582622;
    public static final double MOON_PARALLAX = 0.016592845198710092;

    public static double eccentricAnomaly(double M) {
        double delta;
        double E = M;
        while (!(Math.abs(delta = E - 0.016713 * Math.sin(E) - M) <= 1.0E-10)) {
            E -= delta / (1.0 - 0.016713 * Math.cos(E));
        }
        return E;
    }

    protected static double sunMeanAnomaly(double daysSinceEpoch) {
        double M0;
        double N = ORBIT_RADS_PER_DAY * daysSinceEpoch;
        if ((N %= 6.2831854820251465) < 0.0) {
            N += 6.2831854820251465;
        }
        if ((M0 = N + 4.87650757893409 - 4.935239985213178) < 0.0) {
            M0 += 6.2831854820251465;
        }
        return M0;
    }

    protected static double sunEclipticLongitude(double M0) {
        double E = SunPosition.eccentricAnomaly(M0);
        double v = 2.0 * Math.atan(Math.sqrt(1.033994144130859) * Math.tan(E / 2.0));
        double ret = v + 4.935239985213178;
        ret = SunPosition.adjustWithin2PI(ret);
        return ret;
    }

    protected static double eclipticToEquatorialAscension(double lambda, double beta) {
        double sin_e = Math.sin(0.4091155);
        double cos_e = Math.cos(0.4091155);
        return Math.atan2(Math.sin(lambda) * cos_e - Math.tan(beta) * sin_e, Math.cos(lambda));
    }

    protected static double eclipticToEquatorialDeclination(double lambda, double beta) {
        double sin_e = Math.sin(0.4091155);
        double cos_e = Math.cos(0.4091155);
        return Math.asin(Math.sin(beta) * cos_e + Math.cos(beta) * sin_e * Math.sin(lambda));
    }

    public static double calculateJulianDate(GregorianCalendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        if (++month == 1 || month == 2) {
            --year;
            month += 12;
        }
        int A = year / 100;
        int B = 2 - A + A / 4;
        int C = (int)(365.25 * (double)year);
        int D = (int)(30.6001 * (double)(month + 1));
        double julianDate = (double)(B + C + D + day) + 1720994.5;
        return julianDate;
    }

    public static double greenwichSiderealTime(double julianDate, GregorianCalendar time) {
        double T = (julianDate - 2451545.0) / 36525.0;
        double T0 = 6.697374558 + T * (2400.051336 + (T + 2.5862E-5));
        if ((T0 %= 24.0) < 0.0) {
            T0 += 24.0;
        }
        double UT = (double)time.get(11) + ((double)time.get(12) + (double)time.get(13) / 60.0) / 60.0;
        T0 += UT * 1.002737909;
        if ((T0 %= 24.0) < 0.0) {
            T0 += 24.0;
        }
        return T0;
    }

    public static LatLonPoint sunPosition(long mssue) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(mssue));
        double julianDate = SunPosition.calculateJulianDate(cal);
        long gmtOffset = cal.get(15);
        long dstOffset = cal.get(16);
        cal.setTime(new Date(mssue - (gmtOffset + dstOffset)));
        double numDaysSinceEpoch = ((double)(mssue / 1000L) - 6.310656E8) / 86400.0;
        double M0 = SunPosition.sunMeanAnomaly(numDaysSinceEpoch);
        double sunLongitude = SunPosition.sunEclipticLongitude(M0);
        double sunAscension = SunPosition.eclipticToEquatorialAscension(sunLongitude, 0.0);
        double sunDeclination = SunPosition.eclipticToEquatorialDeclination(sunLongitude, 0.0);
        double tmpAscension = sunAscension - 0.2617993950843811 * SunPosition.greenwichSiderealTime(julianDate, cal);
        return new LatLonPoint((float)sunDeclination, (float)tmpAscension, true);
    }

    public static LatLonPoint moonPosition(long mssue) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(mssue));
        double julianDate = SunPosition.calculateJulianDate(cal);
        long gmtOffset = cal.get(15);
        cal.setTime(new Date(mssue - gmtOffset));
        double numDaysSinceEpoch = ((double)(mssue / 1000L) - 6.310656E8) / 86400.0;
        double M0 = SunPosition.sunMeanAnomaly(numDaysSinceEpoch);
        double sunLongitude = SunPosition.sunEclipticLongitude(M0);
        double el = 13.1763966 * numDaysSinceEpoch * Math.PI / 180.0 + 5.556284436750021;
        el = SunPosition.adjustWithin2PI(el);
        double Mm = el - 0.1114041 * numDaysSinceEpoch * Math.PI / 180.0 - 0.6342598060246725;
        Mm = SunPosition.adjustWithin2PI(Mm);
        double N = 5.559050068029439 - 0.0529539 * numDaysSinceEpoch * Math.PI / 180.0;
        N = SunPosition.adjustWithin2PI(N);
        double C = el - sunLongitude;
        double Ev = 1.2739 * Math.sin(2.0 * C - Mm);
        double Ae = 0.1858 * Math.sin(M0);
        double A3 = 0.37 * Math.sin(M0);
        double Mmp = Mm + Ev - Ae - A3;
        double Ec = 6.2886 * Math.sin(Mmp);
        double A4 = 0.214 * Math.sin(2.0 * Mmp);
        double elp = el + Ev + Ec - Ae + A4;
        double V = 0.6583 * Math.sin(2.0 * (elp - sunLongitude));
        double elpp = elp + V;
        double Np = N - 0.16 * Math.sin(M0);
        double y = Math.sin(elpp - Np) * Math.cos(0.08980410151894615);
        double x = Math.cos(elpp - Np);
        double amb = Math.atan2(y, x);
        double lambda_m = amb + Np;
        double beta_m = Math.asin(Math.sin(elpp - Np) * Math.sin(0.08980410151894615));
        double moonAscension = SunPosition.eclipticToEquatorialAscension(lambda_m, beta_m);
        double moonDeclination = SunPosition.eclipticToEquatorialDeclination(lambda_m, beta_m);
        double tmpAscension = moonAscension - 0.2617993950843811 * SunPosition.greenwichSiderealTime(julianDate, cal);
        return new LatLonPoint((float)moonDeclination, (float)tmpAscension, true);
    }

    protected static double adjustWithin2PI(double num) {
        if (num < 0.0) {
            while ((num += 6.2831854820251465) < 0.0) {
            }
        } else if (num > 6.2831854820251465) {
            while ((num -= 6.2831854820251465) > 6.2831854820251465) {
            }
        }
        return num;
    }

    public static void main(String[] arg) {
        System.out.println("Sun is over " + SunPosition.sunPosition(System.currentTimeMillis()));
        System.out.println("Moon is over " + SunPosition.moonPosition(System.currentTimeMillis()));
    }
}

