/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.util.Debug;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class MiniBrowser
extends OMComponentPanel
implements ActionListener {
    JEditorPane jep;
    Stack stack;
    JButton browserLaunch = null;
    JButton backButton = null;
    JButton dismissButton = null;
    public static final String BackCmd = "back";
    public static final String LaunchBrowserCmd = "browser";

    public MiniBrowser(String content) {
        this("text/html", content);
    }

    public MiniBrowser(String mimeType, String content) {
        this(null, mimeType, content);
    }

    public MiniBrowser(Frame owner, String mimeType, String content) {
        WindowSupport ws = this.init();
        this.push(mimeType, content);
        ws.displayInWindow(owner, 200, 200, 300, 300);
    }

    public MiniBrowser(URL url) {
        this(null, url);
    }

    public MiniBrowser(Frame owner, URL url) {
        WindowSupport ws = this.init();
        this.push(url);
        ws.displayInWindow(owner, 200, 200, 300, 300);
    }

    protected WindowSupport init() {
        this.stack = new Stack();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.browserLaunch = new JButton("Open in Browser");
        URL url = this.getClass().getResource("w.gif");
        ImageIcon imageIcon = new ImageIcon(url, "Go back");
        this.backButton = new JButton(imageIcon);
        this.dismissButton = new JButton("Close");
        this.jep = new JEditorPane();
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                block4: {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block4;
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        Debug.message("minibrowser", "processing HTMLFrameHyperlinkEvent");
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        Debug.message("minibrowser", "processing HyperlinkEvent");
                        try {
                            MiniBrowser.this.push(e.getURL());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        });
        JScrollPane jsp = new JScrollPane(this.jep, 20, 30);
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(jsp, c);
        this.add(jsp);
        JPanel buttonPanel = new JPanel();
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        buttonPanel.setLayout(gridbag2);
        c2.fill = 0;
        c2.anchor = 17;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.backButton.setActionCommand(BackCmd);
        this.backButton.addActionListener(this);
        this.backButton.setEnabled(false);
        gridbag2.setConstraints(this.backButton, c2);
        buttonPanel.add(this.backButton);
        this.browserLaunch.setActionCommand(LaunchBrowserCmd);
        this.browserLaunch.addActionListener(this);
        this.browserLaunch.setVisible(false);
        gridbag2.setConstraints(this.browserLaunch, c2);
        buttonPanel.add(this.browserLaunch);
        WindowSupport ws = new WindowSupport(this, "");
        c2.anchor = 13;
        c2.weightx = 1.0;
        this.dismissButton.setActionCommand("killWindowCmd");
        this.dismissButton.addActionListener(ws);
        gridbag2.setConstraints(this.dismissButton, c2);
        buttonPanel.add(this.dismissButton);
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 1;
        gridbag.setConstraints(buttonPanel, c);
        this.add(buttonPanel);
        return ws;
    }

    public void actionPerformed(ActionEvent ae) {
        block5: {
            String command = ae.getActionCommand();
            try {
                if (command == BackCmd) {
                    this.stack.pop();
                    ((MiniBrowserPage)this.stack.peek()).loadInto(this.jep);
                    if (this.stack.size() > 1) break block5;
                    this.backButton.setEnabled(false);
                    break block5;
                }
                if (command == LaunchBrowserCmd) {
                    ((MiniBrowserPage)this.stack.peek()).launchInBrowser();
                }
            }
            catch (EmptyStackException ese) {
                this.backButton.setEnabled(false);
            }
            catch (IOException ioe) {}
        }
    }

    protected void push(URL newPage) {
        Debug.message("minibrowser", "push(URL)");
        this.push(new MiniBrowserPage(newPage));
    }

    protected void push(String mimeType, String content) {
        Debug.message("minibrowser", "push(String)");
        this.push(new MiniBrowserPage(mimeType, content));
    }

    protected void push(MiniBrowserPage mbp) {
        try {
            mbp.loadInto(this.jep);
            this.stack.push(mbp);
            if (this.stack.size() > 1) {
                this.backButton.setEnabled(true);
            }
        }
        catch (IOException ioe) {}
    }

    protected void enableBrowserLaunch(boolean set) {
        this.browserLaunch.setVisible(set);
        this.invalidate();
    }

    protected void finalize() {
        Debug.message("minibrowser", "MiniBrowser getting gc'd");
    }

    public static void display(String content) {
        MiniBrowser.display("text/html", content);
    }

    public static void display(String mimeType, String content) {
        MiniBrowser.display(null, mimeType, content);
    }

    public static void display(Frame owner, String mimeType, String content) {
        new MiniBrowser(owner, mimeType, content);
    }

    public static void display(URL url) {
        MiniBrowser.display(null, url);
    }

    public static void display(Frame owner, URL url) {
        new MiniBrowser(owner, url);
    }

    public static void main(String[] argv) {
        if (argv.length > 0) {
            try {
                new MiniBrowser(new URL(argv[0]));
            }
            catch (MalformedURLException murle) {
                new MiniBrowser("text/html", argv[0]);
            }
        } else {
            new MiniBrowser("text/html", "String link to the <a href=\"http://openmap.bbn.com\">OpenMap</a> web site");
        }
    }

    public class MiniBrowserPage {
        String content = null;
        String mimeType = null;
        URL url = null;

        public MiniBrowserPage(String mt, String stuff) {
            this.mimeType = mt;
            this.content = stuff;
        }

        public MiniBrowserPage(URL page) {
            this.url = page;
        }

        public void loadInto(JEditorPane jep) throws IOException {
            if (this.isURL()) {
                Debug.message("minibrowser", "loadInto(URL)");
                jep.setPage(this.url);
                MiniBrowser.this.enableBrowserLaunch(true);
                jep.updateUI();
            } else {
                Debug.message("minibrowser", "loadInto(String)");
                jep.setContentType(this.mimeType);
                jep.setText(this.content);
                MiniBrowser.this.enableBrowserLaunch(false);
                jep.updateUI();
            }
        }

        public void launchInBrowser() {
            try {
                if (this.isURL()) {
                    BrowserLauncher.openURL(this.url.toString());
                }
            }
            catch (IOException ioe) {
                Debug.error("MiniBrowser caught IOException loading webpage (" + this.url.toString() + ")\n" + ioe.getMessage());
            }
        }

        public boolean isURL() {
            return this.url != null;
        }
    }
}

