/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.MapBeanKeyListener;
import com.bbn.openmap.event.PanSupport;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.proj.ProjectionStack;
import com.bbn.openmap.proj.ProjectionStackTrigger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Iterator;

public class ProjMapBeanKeyListener
extends MapBeanKeyListener
implements ProjectionStackTrigger {
    protected transient float zoomFactor = 2.0f;
    protected PanSupport panners = new PanSupport(this);
    protected ZoomSupport zoomers = new ZoomSupport(this);
    protected ListenerSupport projListeners = new ListenerSupport(this);

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 38: 
            case 224: {
                this.panners.firePan(0.0f);
                break;
            }
            case 40: 
            case 225: {
                this.panners.firePan(180.0f);
                break;
            }
            case 37: 
            case 226: {
                this.panners.firePan(-90.0f);
                break;
            }
            case 39: 
            case 227: {
                this.panners.firePan(90.0f);
                break;
            }
            case 90: {
                if (e.isShiftDown()) {
                    this.zoomers.fireZoom(301, this.zoomFactor);
                    break;
                }
                this.zoomers.fireZoom(301, 1.0f / this.zoomFactor);
                break;
            }
            case 521: {
                this.zoomers.fireZoom(301, 1.0f / this.zoomFactor);
                break;
            }
            case 45: {
                this.zoomers.fireZoom(301, this.zoomFactor);
                break;
            }
            case 44: {
                this.fireProjectionStackEvent("backProjection");
                break;
            }
            case 46: {
                this.fireProjectionStackEvent("forwardProjection");
            }
        }
    }

    public void setMapBean(MapBean map) {
        if (this.mapBean != null) {
            this.panners.removePanListener(map);
            this.zoomers.removeZoomListener(map);
        }
        super.setMapBean(map);
        if (this.mapBean != null) {
            this.panners.addPanListener(map);
            this.zoomers.addZoomListener(map);
        }
    }

    protected void fireProjectionStackEvent(String command) {
        if (this.projListeners.size() == 0) {
            return;
        }
        ActionEvent event = new ActionEvent(this, 0, command);
        Iterator it = this.projListeners.iterator();
        while (it.hasNext()) {
            ((ActionListener)it.next()).actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener al) {
        this.projListeners.addListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.projListeners.removeListener(al);
    }

    public void updateProjectionStackStatus(boolean containsBackProjections, boolean containsForwardProjections) {
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof ProjectionStack) {
            this.addActionListener((ActionListener)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof ProjectionStack) {
            this.removeActionListener((ActionListener)someObj);
        }
    }
}

