/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.output;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.output.LittleEndianOutputStream;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ShpOutputStream {
    private LittleEndianOutputStream _leos = null;

    public ShpOutputStream(OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this._leos = new LittleEndianOutputStream(bos);
    }

    public int[][] writeGeometry(EsriGraphicList list) throws IOException {
        if (list instanceof EsriPolygonList || list instanceof EsriPolylineList) {
            return this.writePolyGeometry(list);
        }
        if (list instanceof EsriPointList) {
            return this.writePointGeometry(list);
        }
        return null;
    }

    private int[][] createPointIndex(OMGraphicList list) {
        int[][] indexData = new int[2][list.size()];
        int pos = 50;
        int i = 0;
        while (i < list.size()) {
            int contentLength = 0;
            contentLength += 2;
            contentLength += 4;
            indexData[1][i] = contentLength += 4;
            indexData[0][i] = pos;
            pos += contentLength + 4;
            ++i;
        }
        return indexData;
    }

    private int[][] createPolyIndex(EsriGraphicList list) {
        int[][] indexData = new int[2][list.size()];
        int pos = 50;
        int i = 0;
        while (i < list.size()) {
            float[] data;
            int contentLength = 0;
            OMGraphic graphic = list.getOMGraphicAt(i);
            contentLength += 2;
            contentLength += 16;
            contentLength += 2;
            contentLength += 2;
            if (graphic instanceof OMGraphicList) {
                OMGraphicList sublist = (OMGraphicList)graphic;
                contentLength += sublist.size() * 2;
                int j = 0;
                while (j < sublist.size()) {
                    OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
                    data = poly.getLatLonArray();
                    contentLength += data.length * 4;
                    ++j;
                }
            } else {
                contentLength += 2;
                data = ((OMPoly)graphic).getLatLonArray();
                contentLength += data.length * 4;
            }
            indexData[1][i] = contentLength;
            indexData[0][i] = pos;
            pos += contentLength + 4;
            ++i;
        }
        return indexData;
    }

    private int[] getRecordOffsets(int[] contentLengths) {
        int[] offsets = new int[contentLengths.length];
        int pos = 50;
        int i = 0;
        while (i < contentLengths.length) {
            offsets[i] = pos;
            pos += contentLengths[i] + 4;
            ++i;
        }
        return offsets;
    }

    private int[] getPartOffsets(OMGraphicList sublist) {
        int pos = 0;
        int[] offsets = new int[sublist.size()];
        int j = 0;
        while (j < sublist.size()) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
            float[] data = poly.getLatLonArray();
            offsets[j] = pos / 2;
            pos += data.length;
            ++j;
        }
        return offsets;
    }

    private int getPointsPerShape(OMGraphicList sublist) {
        int numPoints = 0;
        int i = 0;
        while (i < sublist.size()) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(i);
            float[] data = poly.getLatLonArray();
            numPoints += data.length;
            ++i;
        }
        return numPoints /= 2;
    }

    private void writeExtents(float[] extents) throws IOException {
        if (this._leos == null) {
            return;
        }
        if (extents[0] == 90.0f && extents[1] == 180.0f && extents[2] == -90.0f && extents[3] == -180.0f) {
            this._leos.writeLEDouble(-180.0);
            this._leos.writeLEDouble(-90.0);
            this._leos.writeLEDouble(180.0);
            this._leos.writeLEDouble(90.0);
        } else {
            this._leos.writeLEDouble(extents[1]);
            this._leos.writeLEDouble(extents[0]);
            this._leos.writeLEDouble(extents[3]);
            this._leos.writeLEDouble(extents[2]);
        }
    }

    public int[][] writePolyGeometry(EsriGraphicList list) throws IOException {
        int numShapes = list.size();
        this._leos.writeInt(9994);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        int[][] indexData = this.createPolyIndex(list);
        int contentLength = list.size();
        contentLength *= 4;
        this._leos.writeInt(contentLength += 50);
        this._leos.writeLEInt(1000);
        this._leos.writeLEInt(list.getType());
        float[] extents = list.getExtents();
        this.writeExtents(extents);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        int i = 0;
        while (i < list.size()) {
            OMPoly poly;
            OMGraphic graphic = list.getOMGraphicAt(i);
            this._leos.writeInt(i + 1);
            this._leos.writeInt(indexData[1][i]);
            this._leos.writeLEInt(list.getType());
            if (graphic instanceof EsriGraphicList) {
                EsriGraphicList sublist = (EsriGraphicList)graphic;
                extents = sublist.getExtents();
                this.writeExtents(extents);
                int numParts = sublist.size();
                this._leos.writeLEInt(numParts);
                int numPoints = this.getPointsPerShape(sublist);
                this._leos.writeLEInt(numPoints);
                int[] offsets = this.getPartOffsets(sublist);
                int j = 0;
                while (j < offsets.length) {
                    this._leos.writeLEInt(offsets[j]);
                    ++j;
                }
                int j2 = 0;
                while (j2 < sublist.size()) {
                    poly = (OMPoly)sublist.getOMGraphicAt(j2);
                    float[] data = poly.getLatLonArray();
                    int n = 0;
                    while (n < data.length) {
                        Float lat = new Float(data[n++]);
                        Float lon = new Float(data[n++]);
                        this._leos.writeLEDouble(Math.toDegrees(lon.doubleValue()));
                        this._leos.writeLEDouble(Math.toDegrees(lat.doubleValue()));
                    }
                    ++j2;
                }
            } else {
                extents = ((EsriGraphic)((Object)graphic)).getExtents();
                this.writeExtents(extents);
                this._leos.writeLEInt(1);
                poly = (OMPoly)graphic;
                float[] data = poly.getLatLonArray();
                this._leos.writeLEInt(data.length / 2);
                this._leos.writeLEInt(0);
                int n = 0;
                while (n < data.length) {
                    Float lat = new Float(data[n++]);
                    Float lon = new Float(data[n++]);
                    this._leos.writeLEDouble(Math.toDegrees(lon.doubleValue()));
                    this._leos.writeLEDouble(Math.toDegrees(lat.doubleValue()));
                }
            }
            ++i;
        }
        this._leos.flush();
        this._leos.close();
        return indexData;
    }

    public int[][] writePointGeometry(EsriGraphicList list) throws IOException {
        this._leos.writeInt(9994);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        int[][] indexData = this.createPointIndex(list);
        int contentLength = list.size() * 4 + 50;
        this._leos.writeInt(contentLength);
        this._leos.writeLEInt(1000);
        this._leos.writeLEInt(list.getType());
        float[] extents = list.getExtents();
        this.writeExtents(extents);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        int i = 0;
        while (i < list.size()) {
            OMPoint point = (OMPoint)list.getOMGraphicAt(i);
            LatLonPoint pt = new LatLonPoint(point.getLat(), point.getLon());
            this._leos.writeInt(i + 1);
            this._leos.writeInt(indexData[1][i]);
            this._leos.writeLEInt(list.getType());
            Float lat = new Float(pt.getLatitude());
            Float lon = new Float(pt.getLongitude());
            this._leos.writeLEDouble(lon.doubleValue());
            this._leos.writeLEDouble(lat.doubleValue());
            ++i;
        }
        this._leos.flush();
        this._leos.close();
        return indexData;
    }
}

