/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.Command;
import java.awt.Polygon;
import java.io.DataInputStream;
import java.io.IOException;

public class PolygonElement
extends Command {
    int[] X;
    int[] Y;
    Polygon P;

    public PolygonElement(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
        int n = this.args.length / 4;
        this.X = new int[n];
        this.Y = new int[n];
        int i = 0;
        while (i < n) {
            this.X[i] = this.makeInt(2 * i);
            this.Y[i] = this.makeInt(2 * i + 1);
            ++i;
        }
    }

    public String toString() {
        String s = "Polygon";
        int i = 0;
        while (i < this.X.length) {
            s = s + " [" + this.X[i] + "," + this.Y[i] + "]";
            ++i;
        }
        return s;
    }

    public void scale(CGMDisplay d) {
        this.P = new Polygon();
        int i = 0;
        while (i < this.X.length) {
            this.P.addPoint(d.x(this.X[i]), d.y(this.Y[i]));
            ++i;
        }
    }

    public void paint(CGMDisplay d) {
        if (d.getFilled()) {
            d.graphics().setColor(d.getFillColor());
            d.graphics().fillPolygon(this.P);
        } else {
            d.graphics().setColor(d.getFillColor());
            if (!d.getEdge()) {
                d.graphics().drawPolygon(this.P);
            }
        }
        if (d.getEdge()) {
            d.graphics().setColor(d.getEdgeColor());
            d.graphics().drawPolygon(this.P);
        }
    }
}

