/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.asrp.ASRPConstants;
import com.bbn.openmap.dataAccess.asrp.ASRPDirectory;
import com.bbn.openmap.dataAccess.asrp.GeneralASRPFile;
import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfield;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TransmittalHeaderFile
extends GeneralASRPFile
implements ASRPConstants {
    public static final String TRANSMITTAL_RECORD = "VDR";
    public static final String DATA_SET_DESCRIPTION = "FDR";
    public static final String SECURITY_AND_RELEASE = "QSR";
    public static final String UP_TO_DATENESS = "QUV";
    protected String rootDir;

    /*
     * WARNING - void declaration
     */
    public TransmittalHeaderFile(String fileName) throws IOException {
        DDFModule mod = this.load(fileName);
        this.rootDir = fileName.substring(0, fileName.indexOf("TRANSH01.THF"));
        if (mod != null) {
            DDFRecord record;
            while ((record = mod.readRecord()) != null) {
                void var3_3;
                Iterator it = var3_3.iterator();
                while (it.hasNext()) {
                    this.addField((DDFField)it.next());
                }
            }
        }
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public List getASRPDirectories() {
        LinkedList<ASRPDirectory> asrpDirs = new LinkedList<ASRPDirectory>();
        List fields = this.getFields(DATA_SET_DESCRIPTION);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            DDFField ddf = (DDFField)it.next();
            if (!ddf.getFieldDefn().getName().equals(DATA_SET_DESCRIPTION)) continue;
            List datasets = ddf.getSubfields("NAM");
            Iterator it2 = datasets.iterator();
            while (it2.hasNext()) {
                DDFSubfield ddfs = (DDFSubfield)it2.next();
                String asrpdString = this.rootDir + "ASRP/" + ddfs.stringValue();
                if (Debug.debugging("asrp")) {
                    Debug.output("TransmittalHeaderFile creating " + asrpdString + " from " + this.rootDir + "TRANSH01.THF");
                }
                asrpDirs.add(new ASRPDirectory(asrpdString));
            }
        }
        return asrpDirs;
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length < 1) {
            Debug.output("Usage: TransmittalHeaderFile filename");
        }
        try {
            TransmittalHeaderFile thf = new TransmittalHeaderFile(argv[0]);
            thf.dumpFields();
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
        }
        System.exit(0);
    }
}

