/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.event.NullMouseMode;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class MouseDelegator
implements PropertyChangeListener,
Serializable,
BeanContextChild,
BeanContextMembershipListener,
SoloMapComponent {
    public static final transient String ActiveModeProperty = "NewActiveMouseMode";
    public static final transient String MouseModesProperty = "NewListOfMouseModes";
    protected transient MapMouseMode activeMouseMode = null;
    protected transient Vector mouseModes = new Vector(0);
    protected transient MapBean map;
    protected Layer[] currentLayers = null;
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);

    public MouseDelegator(MapBean map) {
        this.setMap(map);
    }

    public MouseDelegator() {
        this(null);
    }

    public void setMap(MapBean mapbean) {
        if (this.map != null) {
            this.map.removePropertyChangeListener(this);
            this.setInactive(this.activeMouseMode);
        }
        this.map = mapbean;
        if (this.map != null) {
            this.map.addPropertyChangeListener(this);
            this.setActive(this.activeMouseMode);
        }
    }

    public MapBean getMap() {
        return this.map;
    }

    public String getActiveMouseModeID() {
        if (this.activeMouseMode != null) {
            return this.activeMouseMode.getID();
        }
        return null;
    }

    public void setActiveMouseModeWithID(String MouseModeID) {
        if (MouseModeID == null) {
            Debug.error("MouseDelegator:setActiveMouseModeWithID() - null value");
            return;
        }
        MapMouseMode oldActive = this.activeMouseMode;
        this.setInactive(this.activeMouseMode);
        int i = 0;
        while (i < this.mouseModes.size()) {
            MapMouseMode med = (MapMouseMode)this.mouseModes.elementAt(i);
            if (MouseModeID.equals(med.getID())) {
                this.setActive(med);
                if (!Debug.debugging("mousemode")) break;
                Debug.output("MouseDelegator.setActiveMouseModeWithID() setting new mode to mode " + i + " " + med.getID());
                break;
            }
            ++i;
        }
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public MapMouseMode getActiveMouseMode() {
        return this.activeMouseMode;
    }

    public void setActiveMouseMode(MapMouseMode aMed) {
        if (aMed == null) {
            Debug.error("MouseDelegator:setActiveMouseMode() - null value");
            return;
        }
        MapMouseMode oldActive = this.activeMouseMode;
        boolean isAlreadyAMode = false;
        int i = 0;
        while (i < this.mouseModes.size()) {
            MapMouseMode med = (MapMouseMode)this.mouseModes.elementAt(i);
            if (aMed.getID().equals(med.getID())) {
                isAlreadyAMode = true;
            }
            ++i;
        }
        if (!isAlreadyAMode) {
            this.addMouseMode(aMed);
        }
        this.setActive(aMed);
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public MapMouseMode[] getMouseModes() {
        int nMouseModes = this.mouseModes.size();
        if (nMouseModes == 0) {
            return new MapMouseMode[0];
        }
        MapMouseMode[] result = new MapMouseMode[nMouseModes];
        int i = 0;
        while (i < nMouseModes) {
            result[i] = (MapMouseMode)this.mouseModes.elementAt(i);
            ++i;
        }
        return result;
    }

    public void setMouseModes(MapMouseMode[] meds, int activeIndex) {
        this.mouseModes.removeAllElements();
        MapMouseMode oldActive = this.activeMouseMode;
        int i = 0;
        while (i < meds.length) {
            this.mouseModes.addElement(meds[i]);
            if (i == activeIndex) {
                this.setActive(meds[i]);
            }
            ++i;
        }
        this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public void setMouseModes(MapMouseMode[] meds) {
        this.setMouseModes(meds, 0);
    }

    public void addMouseMode(MapMouseMode med) {
        if (med != null) {
            this.mouseModes.addElement(med);
            if (this.mouseModes.size() == 1) {
                this.setActive(med);
            }
            if (this.currentLayers != null) {
                this.setupMouseModeWithLayers(med, this.currentLayers);
            }
            this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
        }
    }

    public void removeMouseMode(MapMouseMode med) {
        boolean needToAdjustActiveMode = false;
        if (med.equals(this.activeMouseMode)) {
            needToAdjustActiveMode = true;
            this.setInactive(med);
        }
        int i = 0;
        while (i < this.mouseModes.size()) {
            if (med.equals(this.mouseModes.elementAt(i))) {
                med.removeAllMapMouseListeners();
                this.mouseModes.removeElementAt(i);
            } else if (needToAdjustActiveMode) {
                this.setActive(med);
                needToAdjustActiveMode = false;
            }
            ++i;
        }
        this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
    }

    public void removeMouseMode(String id) {
        int i = 0;
        while (i < this.mouseModes.size()) {
            MapMouseMode med = (MapMouseMode)this.mouseModes.elementAt(i);
            if (id.equals(med.getID())) {
                this.removeMouseMode(med);
                break;
            }
            ++i;
        }
    }

    public void setDefaultMouseModes() {
        MapMouseMode[] modes = new MapMouseMode[]{new NavMouseMode(true), new SelectMouseMode(true), new NullMouseMode()};
        this.setMouseModes(modes);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property == "MapBean.layers") {
            Layer[] layers = (Layer[])evt.getNewValue();
            this.currentLayers = new Layer[layers.length];
            System.arraycopy(layers, 0, this.currentLayers, 0, layers.length);
            this.setupMouseModesWithLayers(this.currentLayers);
        }
    }

    public void setupMouseModesWithLayers(Layer[] layers) {
        int j = 0;
        while (j < this.mouseModes.size()) {
            MapMouseMode mmm = (MapMouseMode)this.mouseModes.elementAt(j);
            this.setupMouseModeWithLayers(mmm, layers);
            ++j;
        }
    }

    public void setupMouseModeWithLayers(MapMouseMode mmm, Layer[] layers) {
        mmm.removeAllMapMouseListeners();
        int i = 0;
        while (i < layers.length) {
            String[] services;
            MapMouseListener tempmml = null;
            if (layers[i] != null) {
                tempmml = layers[i].getMapMouseListener();
            }
            if (tempmml != null && (services = tempmml.getMouseModeServiceList()) != null) {
                int k = 0;
                while (k < services.length) {
                    if (mmm.getID().equals(services[k])) {
                        mmm.addMapMouseListener(tempmml);
                        if (!Debug.debugging("mousemode")) break;
                        Debug.output("MouseDelegator.setupMouseModeWithLayers(): layer = " + layers[i].getName() + " service = " + mmm.getID());
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void setActive(MapMouseMode mm) {
        if (this.activeMouseMode != null) {
            this.setInactive(this.activeMouseMode);
        }
        this.activeMouseMode = mm;
        if (this.map != null && this.activeMouseMode != null) {
            if (Debug.debugging("mousemode")) {
                Debug.output("MouseDelegator.setActive(): " + mm.getID());
            }
            this.map.addMouseListener(mm);
            this.map.addMouseMotionListener(mm);
            this.map.addPaintListener(mm);
            this.map.setCursor(this.activeMouseMode.getModeCursor());
            if (mm instanceof ProjectionListener) {
                this.map.addProjectionListener((ProjectionListener)((Object)mm));
            }
            this.activeMouseMode.setActive(true);
        }
    }

    public void setInactive(MapMouseMode mm) {
        if (this.map != null) {
            this.map.removeMouseListener(mm);
            this.map.removeMouseMotionListener(mm);
            this.map.removePaintListener(mm);
            if (mm instanceof ProjectionListener) {
                this.map.removeProjectionListener((ProjectionListener)((Object)mm));
            }
        }
        if (this.activeMouseMode == mm) {
            this.activeMouseMode = null;
        }
        if (mm != null) {
            mm.setActive(false);
        }
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("mousedelegator", "MouseDelegator found a map.");
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof MapMouseMode) {
            Debug.message("mousedelegator", "MouseDelegator found a MapMouseMode.");
            this.addMouseMode((MapMouseMode)someObj);
        }
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean && this.getMap() == (MapBean)someObj) {
            Debug.message("mousedelegator", "MouseDelegator: removing the map.");
            this.setMap(null);
        }
        if (someObj instanceof MapMouseMode) {
            Debug.message("mousedelegator", "MouseDelegator: removing a MapMouseMode.");
            this.removeMouseMode((MapMouseMode)someObj);
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.removePropertyChangeListener(propertyName, in_pcl);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String property, Object oldObj, Object newObj) {
        this.pcSupport.firePropertyChange(property, oldObj, newObj);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }
}

