/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.util.ArrayList;
import java.util.List;

public class ParsedText
extends ParsedTextImpl {
    protected final Matrix textToUserSpaceTransformMatrix;
    protected final GraphicsState gs;

    ParsedText(String text, GraphicsState gs, Matrix textMatrix) {
        this(text, new GraphicsState(gs), textMatrix, ParsedText.convertWidthToUser(ParsedText.getUnscaledFontSpaceWidth(gs), textMatrix.multiply(gs.ctm)));
    }

    ParsedText(String text, GraphicsState gs, Matrix textMatrix, float spaceWidth) {
        super(text, ParsedText.pointToUserSpace(0.0f, 0.0f, textMatrix.multiply(gs.ctm)), ParsedText.pointToUserSpace(ParsedText.getStringWidth(text, gs), 0.0f, textMatrix.multiply(gs.ctm)), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(1, gs.fontSize), textMatrix.multiply(gs.ctm)), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(3, gs.fontSize), textMatrix.multiply(gs.ctm)), spaceWidth);
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.ctm);
        this.getStartPoint();
        this.gs = gs;
    }

    private static Vector pointToUserSpace(float xoffset, float yoffset, Matrix textToUserSpaceTransformMatrix) {
        Vector result = new Vector(xoffset, yoffset, 1.0f).cross(textToUserSpaceTransformMatrix);
        return result;
    }

    private static float getUnscaledFontSpaceWidth(GraphicsState gs) {
        char charToUse = ' ';
        if (gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return ParsedText.getStringWidth(String.valueOf(charToUse), gs);
    }

    private static float getStringWidth(String string, GraphicsState gs) {
        CMapAwareDocumentFont font = gs.font;
        char[] chars = string.toCharArray();
        float totalWidth = 0.0f;
        for (char c : chars) {
            float w = (float)((DocumentFont)font).getWidth(c) / 1000.0f;
            float wordSpacing = c == ' ' ? gs.wordSpacing : 0.0f;
            totalWidth += (w * gs.fontSize + gs.characterSpacing + wordSpacing) * gs.horizontalScaling;
        }
        return totalWidth;
    }

    public List<Word> getAsPartialWords() {
        ArrayList<Word> result = new ArrayList<Word>();
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = this.getText().toCharArray();
        float totalWidth = 0.0f;
        StringBuffer wordAccum = new StringBuffer(3);
        float wordStartOffset = 0.0f;
        for (char c : chars) {
            float wordSpacing;
            float w = (float)((DocumentFont)font).getWidth(c) / 1000.0f;
            if (Character.isSpaceChar(c) && wordAccum.length() > 0) {
                result.add(new Word(wordAccum.toString(), this.getAscent(), this.getDescent(), ParsedText.pointToUserSpace(wordStartOffset, 0.0f, this.textToUserSpaceTransformMatrix), ParsedText.pointToUserSpace(totalWidth, 0.0f, this.textToUserSpaceTransformMatrix), this.getSingleSpaceWidth()));
                wordAccum = new StringBuffer();
                wordSpacing = c == ' ' ? this.gs.wordSpacing : 0.0f;
                wordStartOffset = totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
                continue;
            }
            wordAccum.append(c);
            wordSpacing = c == ' ' ? this.gs.wordSpacing : 0.0f;
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        if (wordAccum.length() > 0) {
            result.add(new Word(wordAccum.toString(), this.getAscent(), this.getDescent(), ParsedText.pointToUserSpace(wordStartOffset, 0.0f, this.textToUserSpaceTransformMatrix), ParsedText.pointToUserSpace(totalWidth, 0.0f, this.textToUserSpaceTransformMatrix), this.getSingleSpaceWidth()));
        }
        return result;
    }

    public float getUnscaledWidth(GraphicsState gs) {
        return ParsedText.getStringWidth(this.getText(), gs);
    }

    private static float convertWidthToUser(float width, Matrix textToUserSpaceTransformMatrix) {
        Vector startPos = ParsedText.pointToUserSpace(0.0f, 0.0f, textToUserSpaceTransformMatrix);
        Vector endPos = ParsedText.pointToUserSpace(width, 0.0f, textToUserSpaceTransformMatrix);
        return ParsedText.distance(startPos, endPos);
    }

    private static float distance(Vector startPos, Vector endPos) {
        return endPos.subtract(startPos).length();
    }

    private static float convertHeightToUser(float height, Matrix textToUserSpaceTransformMatrix) {
        Vector startPos = ParsedText.pointToUserSpace(0.0f, 0.0f, textToUserSpaceTransformMatrix);
        Vector endPos = ParsedText.pointToUserSpace(0.0f, height, textToUserSpaceTransformMatrix);
        return ParsedText.distance(endPos, startPos);
    }

    @Override
    public void accumulate(TextAssembler p, String contextName) {
        p.process(this, contextName);
    }

    @Override
    public void assemble(TextAssembler p) {
        p.renderText(this);
    }

    @Override
    public FinalText getFinalText(PdfReader reader, int page, TextAssembler assembler) {
        throw new RuntimeException("Final text should never be called on unprocessed word fragment.");
    }

    public String toString() {
        return "[ParsedText: [" + this.getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead" + "]";
    }
}

