/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.CfgPropValidator;
import com.isti.util.IstiNamedValueInterface;
import com.isti.util.PropItemInterface;
import com.isti.util.UtilFns;
import com.isti.util.gui.FilteredJTextField;
import com.isti.util.propertyeditor.BooleanPropertyEditor;
import com.isti.util.propertyeditor.ColorPropertyEditor;
import com.isti.util.propertyeditor.FilePropertyEditor;
import com.isti.util.propertyeditor.NumberPropertyEditor;
import com.isti.util.propertyeditor.PropertyEditorInformation;
import com.isti.util.propertyeditor.PropertyEditorLauncher;
import com.isti.util.propertyeditor.RegionPropertyEditor;
import com.isti.util.propertyeditor.StringPropertyEditor;
import com.isti.util.propertyeditor.ValueArrayPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyEditor;
import javax.swing.JLabel;

public class PropertyEditorFactory {
    public static final int NUMERIC_TEXTFIELD_SIZE = 15;
    public static final int STRING_TEXTFIELD_SIZE = 15;

    private PropertyEditorFactory() {
    }

    public static Component createPropertyLabel(String name) {
        return PropertyEditorFactory.createPropertyLabel(name, null);
    }

    public static Component createPropertyLabel(String name, String descriptionStr) {
        String compString = descriptionStr != null && descriptionStr.length() > 0 ? descriptionStr : UtilFns.getPrettyString(name, false);
        JLabel label = new JLabel(compString + ":  ");
        return label;
    }

    public static Component createPropertyLabel(IstiNamedValueInterface item) {
        String descriptionStr = item instanceof PropItemInterface ? ((PropItemInterface)item).getDescriptionStr() : null;
        return PropertyEditorFactory.createPropertyLabel(item.getName(), descriptionStr);
    }

    public static PropertyEditor createPropertyEditor(String name, Object valueObj) {
        return PropertyEditorFactory.createPropertyEditor(name, valueObj, false, null, null);
    }

    public static PropertyEditor createPropertyEditor(String name, Object valueObj, boolean isUnsignedFlag, Comparable maxValue) {
        return PropertyEditorFactory.createPropertyEditor(name, valueObj, isUnsignedFlag, maxValue, null);
    }

    public static PropertyEditor createPropertyEditor(Object[] validValuesArr) {
        return PropertyEditorFactory.createPropertyEditor(null, null, false, null, validValuesArr);
    }

    public static PropertyEditor createPropertyEditor(String name, Object valueObj, boolean isUnsignedFlag, Comparable maxValue, Object[] validValuesArr) {
        String lowerName;
        PropertyEditor propertyeditor = validValuesArr != null && validValuesArr.length > 0 ? new ValueArrayPropertyEditor(validValuesArr) : (valueObj instanceof Number ? new NumberPropertyEditor(valueObj, isUnsignedFlag, maxValue) : (valueObj instanceof Boolean ? new BooleanPropertyEditor() : (valueObj instanceof Color ? new ColorPropertyEditor() : (valueObj instanceof PropertyEditorInformation ? ((PropertyEditorInformation)valueObj).getPropertyEditor() : (name != null ? ((lowerName = name.toLowerCase()).endsWith("file") && valueObj instanceof String ? new FilePropertyEditor() : (lowerName.endsWith("directory") && valueObj instanceof String ? new FilePropertyEditor(true) : (lowerName.endsWith("region") || lowerName.endsWith("regions") ? new PropertyEditorLauncher(new RegionPropertyEditor(), UtilFns.getPrettyString(name)) : new StringPropertyEditor()))) : new StringPropertyEditor())))));
        return propertyeditor;
    }

    public static PropertyEditor createPropertyEditor(IstiNamedValueInterface item) {
        Comparable maxValueObj;
        boolean isUnsignedFlag;
        Object[] validValuesArr;
        CfgPropValidator validatorObj;
        Object auxObj;
        if (item instanceof PropItemInterface) {
            PropItemInterface propItem = (PropItemInterface)item;
            auxObj = propItem.getAuxiliaryObj();
            validatorObj = propItem.getValidator();
        } else {
            auxObj = null;
            validatorObj = null;
        }
        if (auxObj instanceof PropertyEditor) {
            return (PropertyEditor)auxObj;
        }
        if (validatorObj != null) {
            if (validatorObj.allowedChars != null) {
                return new StringPropertyEditor(new FilteredJTextField("", validatorObj.allowedChars));
            }
            validValuesArr = validatorObj.validValuesArr;
            isUnsignedFlag = validatorObj.isMinimumNonNegative();
            maxValueObj = validatorObj.maxValueCompObj;
        } else {
            validValuesArr = null;
            isUnsignedFlag = false;
            maxValueObj = null;
        }
        return PropertyEditorFactory.createPropertyEditor(item.getName(), item.getValue(), isUnsignedFlag, maxValueObj, validValuesArr);
    }
}

