/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.logging;

import com.isti.util.UtilFns;
import com.isti.util.logging.IstiLogger;

public abstract class AbstractIstiLogger
implements IstiLogger {
    public boolean debug(String str) {
        return this.println(0, str);
    }

    public boolean debug2(String str) {
        return this.println(-1, str);
    }

    public boolean debug3(String str) {
        return this.println(-2, str);
    }

    public boolean debug4(String str) {
        return this.println(-3, str);
    }

    public boolean debug5(String str) {
        return this.println(-4, str);
    }

    public boolean error(String str) {
        return this.println(3, str);
    }

    public static String getLevelString(int level) {
        String retStr = AbstractIstiLogger.getLevelStringNull(level);
        return retStr != null ? retStr : "level" + level;
    }

    public static String getLevelStringNull(int level) {
        switch (level) {
            case 3: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Info";
            }
            case 0: {
                return "Debug";
            }
            case -1: {
                return "Debug2";
            }
            case -2: {
                return "Debug3";
            }
            case -3: {
                return "Debug4";
            }
            case -4: {
                return "Debug5";
            }
            case -999: {
                return "ALL_MSGS";
            }
            case 999: {
                return "NO_MSGS";
            }
        }
        return null;
    }

    public boolean info(String str) {
        return this.println(1, str);
    }

    public static Integer levelStringToValue(String str) {
        int val;
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equalsIgnoreCase("Error")) {
            val = 3;
        } else if (str.equalsIgnoreCase("Warning")) {
            val = 2;
        } else if (str.equalsIgnoreCase("Info")) {
            val = 1;
        } else if (str.equalsIgnoreCase("Debug")) {
            val = 0;
        } else if (str.equalsIgnoreCase("Debug2")) {
            val = -1;
        } else if (str.equalsIgnoreCase("Debug3")) {
            val = -2;
        } else if (str.equalsIgnoreCase("Debug4")) {
            val = -3;
        } else if (str.equalsIgnoreCase("Debug5")) {
            val = -4;
        } else if (str.equalsIgnoreCase("ALL_MSGS")) {
            val = -999;
        } else if (str.equalsIgnoreCase("NO_MSGS")) {
            val = 999;
        } else {
            return null;
        }
        return new Integer(val);
    }

    public boolean println(int level, String str) {
        return this.println(level, str, null);
    }

    public boolean println(int level, String str, Throwable t) {
        return this.logMessage(level, this.getMessage(level, str, t), t);
    }

    public boolean println(String str) {
        return this.println(1, str);
    }

    public boolean warning(String str) {
        return this.println(2, str);
    }

    protected String getMessage(int level) {
        return "[" + AbstractIstiLogger.getLevelString(level) + "] ";
    }

    protected String getMessage(int level, String str, Throwable t) {
        if (str == null) {
            str = "";
        } else if (t != null) {
            str = str + UtilFns.newline;
        }
        String levelStr = this.getMessage(level);
        return levelStr + str;
    }

    protected String getMessage(String str, Throwable t) {
        if (t != null) {
            str = str + UtilFns.getStackTraceString(t);
        }
        return str;
    }

    protected abstract boolean logMessage(int var1, String var2, Throwable var3);
}

