/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.SQLTextUtils;
import com.isti.util.gui.textvalidator.TextBasicValidator;
import com.isti.util.gui.textvalidator.TextSQLDateValidator;
import com.isti.util.gui.textvalidator.TextSQLTimeValidator;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class TextSQLTimestampValidator
extends TextBasicValidator {
    public static final String TIME_FIELD_SEPARATOR_CHARS = " ";
    public static final String MS_FIELD_SEPARATOR_CHARS = ".";
    public static final String FIELD_SEPARATOR_CHARS = " .";
    public static final String MS_DESCRIPTION_TEXT = "ms";
    public static final String MS_FORMAT_TEXT = "fffffffff";
    public static final String TIMESTAMP_FORMAT_TEXT = "yyyy-mm-dd" + " ".charAt(0) + "hh:mm:ss" + ".".charAt(0) + "fffffffff";
    public static final String SEPARATOR_CHARS = "-: .";
    public static final String ALLOWED_CHARS = "0123456789-: .";
    private static final String TOOLTIP_TEXT = "year-month-day" + " ".charAt(0) + "hours:minutes:seconds" + ".".charAt(0) + "ms" + " (" + "yyyy-mm-dd" + " ".charAt(0) + "hh:mm:ss" + ".".charAt(0) + "fffffffff" + ")";
    private final int minYear;
    private final int maxYear;

    public TextSQLTimestampValidator() {
        this(-1, -1);
    }

    public TextSQLTimestampValidator(int minYear, int maxYear) {
        super(ALLOWED_CHARS, TIMESTAMP_FORMAT_TEXT.length(), TOOLTIP_TEXT, false, TIMESTAMP_FORMAT_TEXT.length(), true);
        this.minYear = minYear;
        this.maxYear = maxYear;
    }

    public boolean isValid(String s) {
        try {
            SQLTextUtils.TimestampText timestampText = new SQLTextUtils.TimestampText(s);
            if (!TextSQLDateValidator.isValidDate(timestampText.getDateText())) {
                return false;
            }
            if (!TextSQLTimeValidator.isValidTime(timestampText.getTimeText())) {
                return false;
            }
            return timestampText.getMillisecondsText().length() <= MS_FORMAT_TEXT.length();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidEntry(String s) {
        try {
            Timestamp ts = SQLTextUtils.getTimestampValue(s);
            if (ts != null) {
                if (this.minYear >= 0 || this.maxYear >= 0) {
                    GregorianCalendar g = new GregorianCalendar();
                    g.setTime(new Date(ts.getTime()));
                    int year = g.get(1);
                    if (this.minYear >= 0 && year < this.minYear) {
                        return false;
                    }
                    if (this.maxYear >= 0 && year > this.maxYear) {
                        return false;
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

