/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabHistoryListener
implements ChangeListener {
    private final JTabbedPane tabbedPaneObj;
    private final boolean firstTabFlag;
    private final Vector tabsMirrorVec = new Vector();
    private final Vector selTrackingVec = new Vector();
    private boolean inComponentRemovedFlag = false;
    private int lastMovedIdx = -1;

    public TabHistoryListener(JTabbedPane tabbedPaneObj_, boolean firstTabFlag_) {
        this.tabbedPaneObj = tabbedPaneObj_;
        this.firstTabFlag = firstTabFlag_;
        try {
            if (!this.firstTabFlag) {
                int numTabs = this.tabbedPaneObj.getTabCount();
                for (int i = 0; i < numTabs; ++i) {
                    Component compObj = this.tabbedPaneObj.getComponentAt(i);
                    this.tabsMirrorVec.add(compObj);
                    this.selTrackingVec.add(compObj);
                }
                this.moveUpSelected();
            }
            this.tabbedPaneObj.addContainerListener(new ContainerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void componentAdded(ContainerEvent e) {
                    if (!TabHistoryListener.this.firstTabFlag) {
                        TabHistoryListener tabHistoryListener = TabHistoryListener.this;
                        synchronized (tabHistoryListener) {
                            try {
                                Component obj = e.getChild();
                                TabHistoryListener.this.tabsMirrorVec.add(obj);
                                TabHistoryListener.this.selTrackingVec.add(obj);
                                TabHistoryListener.this.moveUpSelected();
                            }
                            catch (Exception ex) {
                                System.err.println("TabHistoryListener:  " + ex);
                                ex.printStackTrace(System.err);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void componentRemoved(ContainerEvent e) {
                    TabHistoryListener tabHistoryListener = TabHistoryListener.this;
                    synchronized (tabHistoryListener) {
                        TabHistoryListener.this.inComponentRemovedFlag = true;
                        try {
                            int removeTabNum;
                            Component removeTabObj = e.getChild();
                            if (removeTabObj instanceof Component && (removeTabNum = TabHistoryListener.this.tabsMirrorVec.indexOf(removeTabObj)) >= 0) {
                                if (!TabHistoryListener.this.firstTabFlag) {
                                    int tabNum;
                                    Object obj;
                                    Object firstObj;
                                    int newVecSize;
                                    int tabCount;
                                    if (TabHistoryListener.this.lastMovedIdx > 0 && removeTabNum >= (tabCount = TabHistoryListener.this.tabsMirrorVec.size()) - 1 && (newVecSize = TabHistoryListener.this.selTrackingVec.size() - 1) > 0 && (firstObj = TabHistoryListener.this.selTrackingVec.firstElement()) instanceof Component && TabHistoryListener.this.tabsMirrorVec.indexOf(firstObj) == tabCount - 2) {
                                        TabHistoryListener.this.selTrackingVec.removeElementAt(0);
                                        int idx = TabHistoryListener.this.lastMovedIdx <= newVecSize ? TabHistoryListener.this.lastMovedIdx : newVecSize;
                                        TabHistoryListener.this.selTrackingVec.add(idx, firstObj);
                                        TabHistoryListener.this.lastMovedIdx = -1;
                                    }
                                    TabHistoryListener.this.tabsMirrorVec.remove(removeTabObj);
                                    if (TabHistoryListener.this.selTrackingVec.remove(removeTabObj) && TabHistoryListener.this.selTrackingVec.size() > 0 && (obj = TabHistoryListener.this.selTrackingVec.firstElement()) instanceof Component && (tabNum = TabHistoryListener.this.tabsMirrorVec.indexOf(obj)) >= 0) {
                                        TabHistoryListener.this.tabbedPaneObj.setSelectedIndex(tabNum);
                                    }
                                } else {
                                    TabHistoryListener.this.tabbedPaneObj.setSelectedIndex(0);
                                }
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("TabHistoryListener:  " + ex);
                            ex.printStackTrace(System.err);
                        }
                        TabHistoryListener.this.inComponentRemovedFlag = false;
                    }
                }
            });
        }
        catch (Exception ex) {
            System.err.println("TabHistoryListener:  " + ex);
            ex.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent e) {
        if (!this.firstTabFlag) {
            TabHistoryListener tabHistoryListener = this;
            synchronized (tabHistoryListener) {
                if (!this.inComponentRemovedFlag) {
                    try {
                        this.moveUpSelected();
                    }
                    catch (Exception ex) {
                        System.err.println("TabHistoryListener:  " + ex);
                        ex.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private void moveUpSelected() {
        Component selObj = this.tabbedPaneObj.getSelectedComponent();
        int pos = this.selTrackingVec.indexOf(selObj);
        if (pos > 0) {
            this.lastMovedIdx = pos;
            this.selTrackingVec.remove(pos);
            this.selTrackingVec.add(0, selObj);
        } else {
            this.lastMovedIdx = -1;
        }
    }
}

