/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.ProgressIndicatorInterface;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.ManagedJProgressBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends IstiDialogPopup {
    public static final String CANCEL_STR = "Cancel";
    private final String buttonStr;
    private final ManagedJProgressBar progressBarObj = new ManagedJProgressBar();
    private JLabel msgLabelObj = null;

    public ProgressDialog(Component parentComp, String titleStr, String msgStr) {
        this(parentComp, titleStr, msgStr, CANCEL_STR, false);
    }

    public ProgressDialog(Component parentComp, String titleStr, String msgStr, String buttonStr, boolean modalFlag) {
        super(parentComp, (Object)new JPanel(new BorderLayout(0, 10)), titleStr, buttonStr, modalFlag);
        this.buttonStr = buttonStr;
        Object obj = this.getMessageObj();
        if (obj instanceof JPanel) {
            JPanel msgPanelObj = (JPanel)obj;
            this.msgLabelObj = new JLabel(msgStr);
            Font fontObj = this.msgLabelObj.getFont();
            this.msgLabelObj.setFont(fontObj.deriveFont(fontObj.getSize2D() + 2.0f));
            msgPanelObj.add((Component)this.msgLabelObj, "Center");
            msgPanelObj.add((Component)this.progressBarObj, "South");
        }
    }

    public String getButtonString() {
        return this.buttonStr;
    }

    public final Object getMessageObj() {
        return super.getMessageObj();
    }

    public String getMessageStr() {
        if (this.msgLabelObj == null) {
            return super.getMessageStr();
        }
        return this.msgLabelObj.getText();
    }

    public ProgressIndicatorInterface getProgressBarObj() {
        return this.progressBarObj;
    }

    public void setMessageObj(Object obj) {
        super.setMessageObj(obj);
        this.msgLabelObj = null;
    }

    public void setMessageStr(final String str) {
        if (this.msgLabelObj == null) {
            super.setMessageStr(str);
        } else if (!this.enforceDispatchThreadFlag || SwingUtilities.isEventDispatchThread()) {
            this.msgLabelObj.setText(str);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressDialog.this.msgLabelObj.setText(str);
                }
            });
        }
    }
}

