/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.FilteredDocument;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FilteredJTextField
extends JTextField {
    public static final String INTEGER_CHARS = "0123456789";
    public static final String HEX_ALPHA_CAP_CHARS = "ABCDEF";
    public static final String HEX_ALPHA_LOW_CHARS = "abcdef";
    public static final String HEX_CHARS = "0123456789ABCDEFabcdef";
    public static final String SIGNED_INT_CHARS = "0123456789-+";
    public static final String FLOAT_CHARS = "0123456789.";
    public static final String SIGNED_FLOAT_CHARS = "0123456789.-+";
    public static final String EFLOAT_CHARS = "0123456789.eE";
    public static final String SIGNED_EFLOAT_CHARS = "0123456789.-+eE";
    public static final String ALPHA_CAP_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHA_LOW_CHARS = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHA_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String ALPHANUMERIC_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String TOD_CHARS = ":.0123456789";
    public static final String WILDCARD_ALL_CHAR = "*";
    public static final String WILDCARD_SINGLE_CHAR = "?";
    public static final String WILDCARD_CHARS = "*?";

    public static final String getAllowedNumberChars(boolean isFloatFlag, boolean isUnsignedFlag) {
        String allowedChars = isFloatFlag ? (isUnsignedFlag ? EFLOAT_CHARS : SIGNED_EFLOAT_CHARS) : (isUnsignedFlag ? INTEGER_CHARS : SIGNED_INT_CHARS);
        return allowedChars;
    }

    public FilteredJTextField() {
    }

    public FilteredJTextField(String text) {
        super(text);
    }

    public FilteredJTextField(String text, String allowedChars, boolean numericFlag) {
        super(new FilteredDocument(allowedChars, numericFlag, 0), text, 0);
    }

    public FilteredJTextField(String text, String allowedChars) {
        super(new FilteredDocument(allowedChars, false, 0), text, 0);
    }

    public FilteredJTextField(String text, int columns, boolean isFloatFlag, boolean isUnsignedFlag) {
        super(new FilteredDocument(FilteredJTextField.getAllowedNumberChars(isFloatFlag, isUnsignedFlag), true, 0), text, columns);
    }

    public FilteredJTextField(String text, int columns, String allowedChars, boolean numericFlag) {
        super(new FilteredDocument(allowedChars, numericFlag, 0), text, columns);
    }

    public FilteredJTextField(String text, int columns, String allowedChars) {
        super(new FilteredDocument(allowedChars, false, 0), text, columns);
    }

    public FilteredJTextField(int columns, String allowedChars) {
        super(new FilteredDocument(allowedChars, false, 0), null, columns);
    }

    public FilteredJTextField(int maxNumChars) {
        super(new FilteredDocument(null, false, maxNumChars), null, 0);
    }

    public FilteredJTextField(String text, int maxNumChars) {
        super(new FilteredDocument(null, false, maxNumChars), text, 0);
    }

    public FilteredJTextField(String text, String allowedChars, boolean numericFlag, int maxNumChars) {
        super(new FilteredDocument(allowedChars, numericFlag, maxNumChars), text, 0);
    }

    public FilteredJTextField(String text, String allowedChars, int maxNumChars) {
        super(new FilteredDocument(allowedChars, false, maxNumChars), text, 0);
    }

    public FilteredJTextField(String text, int columns, String allowedChars, boolean numericFlag, int maxNumChars) {
        super(new FilteredDocument(allowedChars, numericFlag, maxNumChars), text, columns);
    }

    public FilteredJTextField(String text, int columns, String specialChars, boolean numericFlag, int maxNumChars, boolean allowFlag) {
        super(new FilteredDocument(specialChars, numericFlag, maxNumChars, allowFlag), text, columns);
    }

    public FilteredJTextField(String text, int columns, String allowedChars, int maxNumChars) {
        super(new FilteredDocument(allowedChars, false, maxNumChars), text, columns);
    }

    public FilteredJTextField setMaxValue(Comparable compObj) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(compObj);
        }
        return this;
    }

    public int getIntegerValue() {
        try {
            if (this.getText() != null && this.getText().length() > 0) {
                return new Integer(this.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public Comparable getMaxValueObj() {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            return ((FilteredDocument)docObj).getMaxValueObj();
        }
        return null;
    }

    public FilteredJTextField setMaxValue(int val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Integer(val));
        }
        return this;
    }

    public FilteredJTextField setMaxValue(long val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Long(val));
        }
        return this;
    }

    public FilteredJTextField setMaxValue(short val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Short(val));
        }
        return this;
    }

    public FilteredJTextField setMaxValue(byte val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Byte(val));
        }
        return this;
    }

    public FilteredJTextField setMaxValue(double val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Double(val));
        }
        return this;
    }

    public FilteredJTextField setMaxValue(float val) {
        Document docObj = this.getDocument();
        if (docObj instanceof FilteredDocument) {
            ((FilteredDocument)docObj).setMaxValueObj(new Float(val));
        }
        return this;
    }
}

