/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.CallBackCompletion;
import com.isti.util.database.ConnectionJDBC;
import java.sql.SQLException;
import java.util.Properties;

public class MySQLConnectionJDBC
extends ConnectionJDBC {
    protected static final String MYSQL_DRIVER_NAME = "com.mysql.jdbc.Driver";
    private static boolean mySQLDriverLoaded = false;

    public static void registerDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (!mySQLDriverLoaded) {
            ConnectionJDBC.registerDriver(MYSQL_DRIVER_NAME);
            mySQLDriverLoaded = true;
        }
    }

    public static void deregisterDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (mySQLDriverLoaded) {
            ConnectionJDBC.deregisterDriver(MYSQL_DRIVER_NAME);
            mySQLDriverLoaded = false;
        }
    }

    public MySQLConnectionJDBC(String hostName, String[] failOverHostNames, String port, String dataBase, String userName, String passWord, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this(MySQLConnectionJDBC.getUrl(hostName, failOverHostNames, port, dataBase), ConnectionJDBC.saveUserPassword(null, userName, passWord), callBack);
    }

    public MySQLConnectionJDBC(String url, Properties info, CallBackCompletion callBack) {
        super(url, info, callBack);
    }

    public static String getUrl(String hostName, String[] failOverHostNames, String port, String dataBase) {
        String urlString = "jdbc:mysql://";
        if (hostName != null && hostName.length() > 0) {
            urlString = urlString + hostName;
        }
        if (failOverHostNames != null) {
            for (int i = 0; i < failOverHostNames.length; ++i) {
                String failOverHostName = failOverHostNames[i];
                if (failOverHostName == null || failOverHostName.length() <= 0) continue;
                urlString = urlString + "," + failOverHostName;
            }
        }
        if (port != null && port.length() > 0) {
            urlString = urlString + ":" + port;
        }
        urlString = urlString + "/";
        if (dataBase != null && dataBase.length() > 0) {
            urlString = urlString + dataBase;
        }
        return urlString;
    }
}

