/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.ArchiveManager;
import com.isti.util.IstiMessageObjectCache;
import com.isti.util.IstiNotifyThread;
import com.isti.util.IstiThread;
import com.isti.util.IstiTimeObjectCache;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class IstiMessageCachedArchive {
    protected final IstiMessageObjectCache messageCacheObj;
    protected final ArchiveManager archiveMgrObj;
    protected long cacheRemoveAgeMilliSecs;
    protected long archiveRemoveAgeMilliSecs;
    protected long maxRequestAgeMilliSecs;
    protected final LogFile logObj;
    protected final Object dataAccessSyncObj;
    protected final Vector addMessageQueueVec = new Vector();
    protected final AddMessageWorkerThread addMessageWorkerThreadObj = new AddMessageWorkerThread();
    protected boolean closingCacheArchiveFlag = false;

    public IstiMessageCachedArchive(ArchiveManager archiveMgrObj, LogFile logObj, long tolerance, int cacheRemoveAgeSecs, int cacheMaxObjectCount, long cacheMaxTotalDataSize, int archiveRemoveAgeSecs, int maxRequestAgeSecs, boolean useLookupKeyFlag) {
        if (archiveMgrObj == null) {
            throw new NullPointerException("ArchiveManager parameter is null");
        }
        if (cacheRemoveAgeSecs == 0) {
            throw new RuntimeException("Cache-remove-age parameter cannot be zero");
        }
        this.archiveMgrObj = archiveMgrObj;
        this.logObj = logObj;
        this.cacheRemoveAgeMilliSecs = (long)cacheRemoveAgeSecs * 1000L;
        this.archiveRemoveAgeMilliSecs = (long)archiveRemoveAgeSecs * 1000L;
        this.maxRequestAgeMilliSecs = (long)maxRequestAgeSecs * 1000L;
        this.messageCacheObj = new IstiMessageObjectCache(logObj, tolerance, this.cacheRemoveAgeMilliSecs, null, useLookupKeyFlag);
        this.messageCacheObj.setMaximumObjectCount(cacheMaxObjectCount);
        this.messageCacheObj.setMaximumTotalDataSize(cacheMaxTotalDataSize);
        this.dataAccessSyncObj = archiveMgrObj.getArchiveAccessSyncObj();
        this.addMessageWorkerThreadObj.start();
    }

    public IstiMessageCachedArchive(ArchiveManager archiveMgrObj, LogFile logObj, long tolerance, int cacheRemoveAgeSecs, int archiveRemoveAgeSecs, int maxRequestAgeSecs, boolean useLookupKeyFlag) {
        this(archiveMgrObj, logObj, tolerance, cacheRemoveAgeSecs, 0, 0L, archiveRemoveAgeSecs, maxRequestAgeSecs, useLookupKeyFlag);
    }

    public IstiMessageCachedArchive(ArchiveManager archiveMgrObj, LogFile logObj, long tolerance, int cacheRemoveAgeSecs, int cacheMaxObjectCount, long cacheMaxTotalDataSize, int archiveRemoveAgeSecs, int maxRequestAgeSecs) {
        this(archiveMgrObj, logObj, tolerance, cacheRemoveAgeSecs, cacheMaxObjectCount, cacheMaxTotalDataSize, archiveRemoveAgeSecs, maxRequestAgeSecs, true);
    }

    public IstiMessageCachedArchive(ArchiveManager archiveMgrObj, LogFile logObj, long tolerance, int cacheRemoveAgeSecs, int archiveRemoveAgeSecs, int maxRequestAgeSecs) {
        this(archiveMgrObj, logObj, tolerance, cacheRemoveAgeSecs, 0, 0L, archiveRemoveAgeSecs, maxRequestAgeSecs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivableMsgObj(ArchivableMsgObjEntry archivableMsgObj) {
        Vector vector = this.addMessageQueueVec;
        synchronized (vector) {
            this.addMessageQueueVec.add(archivableMsgObj);
            this.addMessageWorkerThreadObj.notifyThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddArchivableMsgObj(ArchivableMsgObjEntry archivableMsgObj) throws IOException {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            if (!this.messageCacheObj.containsObjectKey(archivableMsgObj)) {
                long curTime;
                long msgTime = archivableMsgObj.getTimeGenerated();
                if (msgTime > (curTime = System.currentTimeMillis()) - this.cacheRemoveAgeMilliSecs) {
                    this.messageCacheObj.addMsgObjEntry(archivableMsgObj);
                } else if (this.logObj != null) {
                    this.logObj.debug2(this.getLogPrefixString() + ":  Entry not added to cache; too old (msgNum=" + archivableMsgObj.getMsgNum() + ", msgDate=\"" + UtilFns.timeMillisToString(archivableMsgObj.getArchiveDate().getTime(), true) + "\")");
                    this.logObj.debug3(this.getLogPrefixString() + ":  dataStr = \"" + archivableMsgObj.getKeyStr() + "\"");
                }
                if (this.archiveRemoveAgeMilliSecs <= 0L || msgTime > curTime - this.archiveRemoveAgeMilliSecs) {
                    this.archiveMgrObj.archiveItem(archivableMsgObj);
                } else if (this.logObj != null) {
                    this.logObj.debug2(this.getLogPrefixString() + ":  Entry not added to archive; too old (msgNum=" + archivableMsgObj.getMsgNum() + ", msgDate=\"" + UtilFns.timeMillisToString(archivableMsgObj.getArchiveDate().getTime(), true) + "\")");
                    this.logObj.debug3(this.getLogPrefixString() + ":  dataStr = \"" + archivableMsgObj.getKeyStr() + "\"");
                }
            } else if (this.logObj != null) {
                this.logObj.debug2(this.getLogPrefixString() + ":  Entry not added because " + "matching msg-object-key already in cache (msgNum=" + archivableMsgObj.getMsgNum() + ", msgDate=\"" + UtilFns.timeMillisToString(archivableMsgObj.getArchiveDate().getTime(), true) + "\")");
                this.logObj.debug3(this.getLogPrefixString() + ":  dataStr = \"" + archivableMsgObj.getKeyStr() + "\"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IstiTimeObjectCache.VectorWithCount getMessages(long beginTime, long beginMsgNum, final long endTime, final long endMsgNum, int maxCount, boolean cacheOnlyFlag) {
        if (this.logObj != null) {
            this.logObj.debug3(this.getLogPrefixString() + ".getMessages(), beginTime=" + beginTime + ", beginMsgNum=" + beginMsgNum + ", endTime=" + endTime + ", endMsgNum=" + endMsgNum + ", maxCount=" + maxCount);
        }
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            int cacheMaxCount;
            IstiTimeObjectCache.VectorWithCount cacheVec;
            int cacheVecSize;
            int archiveVecSize;
            IstiTimeObjectCache.VectorWithCount archiveVec;
            boolean beginTimeInCacheFlag;
            long archiveFetchEndTime;
            ArchivableMsgObjEntry firstCacheMsgObj;
            IstiMessageObjectCache.MessageObjectEntry obj;
            long maxRequestTimeVal;
            if (this.maxRequestAgeMilliSecs > 0L && beginTime < (maxRequestTimeVal = System.currentTimeMillis() - this.maxRequestAgeMilliSecs)) {
                if (this.logObj != null) {
                    this.logObj.debug(this.getLogPrefixString() + ".getMessages():  Requested begin time (" + beginTime + ") adjusted to " + this.maxRequestAgeMilliSecs + "ms limit (" + maxRequestTimeVal + ")");
                }
                beginTime = maxRequestTimeVal;
                beginMsgNum = 0L;
            }
            if ((obj = this.messageCacheObj.getFirstMessage()) instanceof ArchivableMsgObjEntry) {
                firstCacheMsgObj = (ArchivableMsgObjEntry)obj;
                archiveFetchEndTime = firstCacheMsgObj.getTimeGenerated();
                if (endTime > 0L && archiveFetchEndTime > endTime) {
                    archiveFetchEndTime = endTime;
                }
                beginTimeInCacheFlag = beginMsgNum > 0L ? beginTime >= firstCacheMsgObj.getTimeGenerated() : beginTime > firstCacheMsgObj.getTimeGenerated();
            } else {
                firstCacheMsgObj = null;
                archiveFetchEndTime = endTime;
                beginTimeInCacheFlag = false;
            }
            if (!beginTimeInCacheFlag && !cacheOnlyFlag) {
                archiveVec = new IstiTimeObjectCache.VectorWithCount();
                Date archiveBeginDateObj = beginTime > 0L ? new Date(beginTime) : null;
                Date archiveEndDateObj = archiveFetchEndTime > 0L ? new Date(archiveFetchEndTime) : null;
                final long reqBeginTime = beginTime;
                final long reqBeginMsgNum = beginMsgNum;
                this.archiveMgrObj.processArchivedItems(archiveBeginDateObj, archiveEndDateObj, new ArchiveManager.ProcessCallBack(){

                    public boolean procArchivedItem(Archivable itemObj, String archivedFormStr) {
                        if (IstiMessageCachedArchive.this.closingCacheArchiveFlag) {
                            return false;
                        }
                        if (itemObj instanceof ArchivableMsgObjEntry) {
                            ArchivableMsgObjEntry msgObj = (ArchivableMsgObjEntry)itemObj;
                            if (reqBeginMsgNum > 0L && msgObj.getMsgNum() == reqBeginMsgNum && msgObj.getTimeGenerated() == reqBeginTime) {
                                archiveVec.clear();
                                return true;
                            }
                            if (endMsgNum > 0L && msgObj.getMsgNum() == endMsgNum && msgObj.getTimeGenerated() == endTime) {
                                return false;
                            }
                        }
                        if (firstCacheMsgObj != null && (archivedFormStr != null && archivedFormStr.length() > 0 ? archivedFormStr.equals(firstCacheMsgObj.toArchivedForm()) : itemObj.equals(firstCacheMsgObj))) {
                            return false;
                        }
                        archiveVec.add(itemObj);
                        return true;
                    }
                }, maxCount > 0 ? maxCount + 2 : 0);
                archiveVecSize = archiveVec.size();
                if (this.logObj != null) {
                    this.logObj.debug3(this.getLogPrefixString() + ".getMessages():  " + "Matching # from archive = " + archiveVecSize);
                }
                if (maxCount > 0 && archiveVecSize >= maxCount) {
                    if (this.logObj != null) {
                        this.logObj.debug3(this.getLogPrefixString() + ".getMessages():  " + "Item-count limit reached via fetch from archive " + "(numFetched=" + archiveVecSize + ")");
                    }
                    int p = archiveVecSize;
                    while (p > maxCount) {
                        archiveVec.removeElementAt(--p);
                    }
                    archiveVec.setCount(archiveVecSize + maxCount);
                    return archiveVec;
                }
            } else {
                archiveVec = null;
                archiveVecSize = 0;
            }
            if (firstCacheMsgObj != null && (endTime <= 0L || endTime >= firstCacheMsgObj.getTimeGenerated()) && (cacheVecSize = (cacheVec = this.messageCacheObj.getMessages(beginTime, beginMsgNum, endTime, endMsgNum, cacheMaxCount = maxCount > 0 ? maxCount - archiveVecSize : 0)).size()) > 0) {
                if (this.logObj != null) {
                    this.logObj.debug3(this.getLogPrefixString() + ".getMessages():  " + "Matching # from cache = " + cacheVecSize);
                }
                if (archiveVec == null || archiveVecSize <= 0) {
                    return cacheVec;
                }
                archiveVec.addAll(cacheVec);
                archiveVec.setCount(archiveVecSize + cacheVec.getCount());
                return archiveVec;
            }
            if (archiveVec != null) {
                archiveVec.setCount(archiveVecSize);
                return archiveVec;
            }
            return new IstiTimeObjectCache.VectorWithCount();
        }
    }

    public IstiTimeObjectCache.VectorWithCount getMessages(long beginTime, long beginMsgNum, long endTime, long endMsgNum, int maxCount) {
        return this.getMessages(beginTime, beginMsgNum, endTime, endMsgNum, maxCount, false);
    }

    public IstiTimeObjectCache.VectorWithCount getMessages(long beginTime, long beginMsgNum, long endTime, long endMsgNum) {
        return this.getMessages(beginTime, beginMsgNum, endTime, endMsgNum, 0, false);
    }

    public IstiTimeObjectCache.VectorWithCount getNewerMessages(long time, long msgNum, int maxCount, boolean cacheOnlyFlag) {
        return this.getMessages(time, msgNum, 0L, 0L, maxCount, cacheOnlyFlag);
    }

    public IstiTimeObjectCache.VectorWithCount getNewerMessages(long time, long msgNum, int maxCount) {
        return this.getMessages(time, msgNum, 0L, 0L, maxCount, false);
    }

    public IstiTimeObjectCache.VectorWithCount getNewerMessages(long time, long msgNum) {
        return this.getMessages(time, msgNum, 0L, 0L, 0, false);
    }

    public IstiTimeObjectCache.VectorWithCount getOlderMessages(long time, long msgNum, int maxCount) {
        return this.getMessages(0L, 0L, time, msgNum, maxCount, false);
    }

    public IstiTimeObjectCache.VectorWithCount getOlderMessages(long time, long msgNum) {
        return this.getMessages(0L, 0L, time, msgNum, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadCacheFromArchive() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            long timeVal;
            this.archiveMgrObj.processArchivedItems(new Date(System.currentTimeMillis() - this.cacheRemoveAgeMilliSecs), null, new ArchiveManager.ProcessCallBack(){

                public boolean procArchivedItem(Archivable itemObj, String archivedFormStr) {
                    if (itemObj instanceof ArchivableMsgObjEntry) {
                        IstiMessageCachedArchive.this.messageCacheObj.addMsgObjEntry((ArchivableMsgObjEntry)itemObj);
                    }
                    return true;
                }
            });
            if (this.logObj != null && (timeVal = this.messageCacheObj.getLastMsgNumSeqBreakTime()) > 0L) {
                this.logObj.debug(this.getLogPrefixString() + ":  Time of last detected " + "break in message # sequence in cache (" + timeVal + ") = " + UtilFns.timeMillisToString(timeVal, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOldObjects() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            boolean retFlag = this.messageCacheObj.removeOldObjects();
            if (this.archiveRemoveAgeMilliSecs > 0L) {
                this.archiveMgrObj.purgeArchive(new Date(System.currentTimeMillis() - this.archiveRemoveAgeMilliSecs));
            }
            return retFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheContains(ArchivableMsgObjEntry archivableMsgObj) {
        Vector vector = this.addMessageQueueVec;
        synchronized (vector) {
            if (this.addMessageQueueVec.size() > 0) {
                Iterator iterObj = ((AbstractList)this.addMessageQueueVec).iterator();
                while (iterObj.hasNext()) {
                    if (!archivableMsgObj.equals(iterObj.next())) continue;
                    return true;
                }
            }
            return this.messageCacheObj.getUseLookupKeyFlag() ? this.messageCacheObj.containsObjectKey(archivableMsgObj) : this.messageCacheObj.containsEntry(archivableMsgObj);
        }
    }

    public boolean isCacheEmpty() {
        return this.messageCacheObj.isEmpty();
    }

    public int getCacheSize() {
        return this.messageCacheObj.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivableMsgObjEntry getLastCacheMessageObj() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            IstiMessageObjectCache.MessageObjectEntry entryObj = this.messageCacheObj.getLastMessage();
            return entryObj instanceof ArchivableMsgObjEntry ? (ArchivableMsgObjEntry)entryObj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivableMsgObjEntry getLastArchiveMessageObj() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            Archivable archivableObj = this.archiveMgrObj.getNewestItemInEntireArchive();
            return archivableObj instanceof ArchivableMsgObjEntry ? (ArchivableMsgObjEntry)archivableObj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivableMsgObjEntry getLastMessageObj() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            return this.messageCacheObj.isEmpty() ? this.getLastArchiveMessageObj() : this.getLastCacheMessageObj();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastCacheMsgNum() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            return this.messageCacheObj.getLastMsgNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastArchiveMsgNum() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            Archivable archivableObj = this.archiveMgrObj.getNewestItemInEntireArchive();
            if (archivableObj instanceof ArchivableMsgObjEntry) {
                return ((ArchivableMsgObjEntry)archivableObj).getMsgNum();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastMsgNumber() {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            return this.messageCacheObj.isEmpty() ? this.getLastArchiveMsgNum() : this.getLastCacheMsgNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheRemoveAgeSecs(int ageInSecs) {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.cacheRemoveAgeMilliSecs = (long)ageInSecs * 1000L;
            this.messageCacheObj.setDefaultRemoveAge(this.cacheRemoveAgeMilliSecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheMaxObjectCount(int val) {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.messageCacheObj.setMaximumObjectCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheMaxTotalDataSize(long val) {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.messageCacheObj.setMaximumTotalDataSize(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchiveRemoveAgeSecs(int ageInSecs) {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.archiveRemoveAgeMilliSecs = (long)ageInSecs * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRequestAgeSecs(int ageInSecs) {
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.maxRequestAgeMilliSecs = (long)ageInSecs * 1000L;
        }
    }

    public boolean isAddMessageQueueEmpty() {
        return this.addMessageQueueVec.isEmpty();
    }

    public boolean waitForAddMessageQueueEmpty(long maxWaitMs) {
        if (this.addMessageQueueVec.isEmpty()) {
            return true;
        }
        long timeoutTime = maxWaitMs > 0L ? System.currentTimeMillis() + maxWaitMs : 0L;
        long delayValMs = maxWaitMs > 0L && maxWaitMs < 1000L ? maxWaitMs / 10L : 1000L;
        do {
            try {
                Thread.sleep(delayValMs);
            }
            catch (InterruptedException ex) {
                break;
            }
            if (!this.addMessageQueueVec.isEmpty()) continue;
            return true;
        } while (maxWaitMs <= 0L || System.currentTimeMillis() <= timeoutTime);
        return this.addMessageQueueVec.isEmpty();
    }

    public Object getDataAccessSyncObj() {
        return this.dataAccessSyncObj;
    }

    public IstiMessageObjectCache getMessageCacheObj() {
        return this.messageCacheObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closingCacheArchiveFlag = true;
        this.addMessageWorkerThreadObj.terminate();
        Object object = this.dataAccessSyncObj;
        synchronized (object) {
            this.archiveMgrObj.closeArchive();
            if (this.logObj != null) {
                this.logObj.debug(this.getLogPrefixString() + ":  Archive manager closed");
            }
            this.messageCacheObj.close();
        }
    }

    protected String getLogPrefixString() {
        return "IstiMessageCachedArchive";
    }

    public static abstract class BasicArchivableMsgObjEntry
    extends IstiMessageObjectCache.BasicMessageObjectEntry
    implements ArchivableMsgObjEntry {
        public BasicArchivableMsgObjEntry(long timeGenerated, Object msgObj, String msgStr, long msgNum) {
            super(timeGenerated, msgObj, msgStr, msgNum);
        }

        protected BasicArchivableMsgObjEntry() {
        }

        public Date getArchiveDate() {
            return new Date(this.timeGenerated);
        }

        public abstract /* synthetic */ String toArchivedForm();
    }

    public static interface ArchivableMsgObjEntry
    extends IstiMessageObjectCache.MessageObjectEntry,
    Archivable {
    }

    public class AddMessageWorkerThread
    extends IstiNotifyThread {
        public AddMessageWorkerThread() {
            super("msgCachedArchiveAddThread-" + IstiThread.nextThreadNum());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (true) {
                this.waitForNotify();
                if (this.isTerminated()) break;
                if (IstiMessageCachedArchive.this.addMessageQueueVec.size() <= 0) continue;
                do {
                    block9: {
                        try {
                            IstiMessageCachedArchive.this.doAddArchivableMsgObj((ArchivableMsgObjEntry)IstiMessageCachedArchive.this.addMessageQueueVec.elementAt(0));
                        }
                        catch (Exception ex) {
                            if (IstiMessageCachedArchive.this.logObj == null) break block9;
                            IstiMessageCachedArchive.this.logObj.warning(IstiMessageCachedArchive.this.getLogPrefixString() + ":  Error adding message to cache or archive:  " + ex);
                            IstiMessageCachedArchive.this.logObj.warning(UtilFns.getStackTraceString(ex));
                        }
                    }
                    Vector vector = IstiMessageCachedArchive.this.addMessageQueueVec;
                    synchronized (vector) {
                        IstiMessageCachedArchive.this.addMessageQueueVec.remove(0);
                        if (IstiMessageCachedArchive.this.addMessageQueueVec.size() <= 0) {
                            this.clearThreadWaitNotifyFlag();
                            continue block5;
                        }
                    }
                } while (!this.isTerminated());
                break;
            }
        }
    }
}

