/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import com.isti.util.LogFile;
import com.isti.util.ProgramSingleton;
import com.isti.util.UtilFns;
import java.io.File;

public class DupJarLauncher {
    private static String MSG_PROMPT = "DupJarLauncher:  ";

    private DupJarLauncher() {
    }

    public static String launch(String origJarFNameStr, String dupJarFNameStr, String progClassNameStr, String progSingletonNameStr, String jvmParamsStr, String progParamsStr, LogFile logObj, String progSingletonDirStr) {
        try {
            ProgramSingleton progSingletonObj;
            if (logObj == null) {
                logObj = LogFile.getNullLogObj();
            }
            ProgramSingleton programSingleton = progSingletonObj = progSingletonDirStr != null && progSingletonDirStr.trim().length() > 0 ? new ProgramSingleton(progSingletonDirStr, progSingletonNameStr) : new ProgramSingleton(progSingletonNameStr);
            if (progSingletonNameStr != null && progSingletonNameStr.length() > 0 && progSingletonObj.isRunning()) {
                logObj.warning(MSG_PROMPT + "Error launching program class (\"" + progClassNameStr + "\"):  Program already running");
                return "Program is already running";
            }
            String launchJarFNameStr = dupJarFNameStr;
            try {
                File origJarFileObj = new File(origJarFNameStr);
                File dupJarFileObj = new File(dupJarFNameStr);
                if (dupJarFileObj.exists()) {
                    if (origJarFileObj.exists()) {
                        if (origJarFileObj.lastModified() > dupJarFileObj.lastModified()) {
                            logObj.debug(MSG_PROMPT + "Copying updated \"" + origJarFileObj + "\" to \"" + dupJarFileObj + "\"");
                            FileUtils.copyFile(origJarFileObj, dupJarFileObj);
                        }
                    } else {
                        logObj.debug(MSG_PROMPT + "Original jar not found (\"" + origJarFNameStr + "\")");
                    }
                } else if (origJarFileObj.exists()) {
                    logObj.debug(MSG_PROMPT + "Copying \"" + origJarFileObj + "\" to \"" + dupJarFileObj + "\"");
                    FileUtils.copyFile(origJarFileObj, dupJarFileObj);
                } else {
                    logObj.warning(MSG_PROMPT + "Error launching program class (\"" + progClassNameStr + "\"):  Original jar not found (\"" + origJarFNameStr + "\")");
                    return "Error launching program:  jar file (\"" + origJarFNameStr + "\") not found";
                }
                if (!dupJarFileObj.exists()) {
                    logObj.warning(MSG_PROMPT + "Unable to find copied program jar file; using original jar");
                    launchJarFNameStr = origJarFNameStr;
                }
            }
            catch (Exception ex) {
                logObj.warning(MSG_PROMPT + "Error copying program jar file; using original jar:  " + ex);
                launchJarFNameStr = origJarFNameStr;
            }
            String cmdStr = "java" + (jvmParamsStr != null && jvmParamsStr.length() > 0 ? " " + jvmParamsStr : "") + " -cp " + launchJarFNameStr + " " + progClassNameStr + (progParamsStr != null && progParamsStr.length() > 0 ? " " + progParamsStr : "");
            logObj.debug(MSG_PROMPT + "Executing command:  " + cmdStr);
            Runtime.getRuntime().exec(cmdStr);
            return null;
        }
        catch (Exception ex) {
            logObj.warning(MSG_PROMPT + "Error launching program class (\"" + progClassNameStr + "\"):  " + ex);
            logObj.warning(UtilFns.getStackTraceString(ex));
            return "Error launching program:  " + ex;
        }
    }

    public static String launch(String origJarFNameStr, String dupJarFNameStr, String progClassNameStr, String progSingletonNameStr, String jvmParamsStr, String progParamsStr, LogFile logObj) {
        return DupJarLauncher.launch(origJarFNameStr, dupJarFNameStr, progClassNameStr, progSingletonNameStr, jvmParamsStr, progParamsStr, logObj, null);
    }
}

