/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.legends;

import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import java.text.Format;
import java.text.NumberFormat;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueLegend
extends AbstractLegend
implements DataListener {
    private static final long serialVersionUID = -4274009997506638823L;
    public static final Key LABEL_COLUMN = new Key("valueLegend.label.column");
    public static final Key LABEL_FORMAT = new Key("valueLegend.label.format");

    public ValueLegend() {
        this.setSettingDefault(LABEL_COLUMN, 0);
    }

    @Override
    protected Iterable<Row> getEntries(DataSource dataSource) {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        for (int i = 0; i < dataSource.getRowCount(); ++i) {
            Row row = new Row(dataSource, i);
            linkedList.add(row);
        }
        return linkedList;
    }

    @Override
    protected String getLabel(Row row) {
        int n = (Integer)this.getSetting(LABEL_COLUMN);
        Comparable<?> comparable = row.get(n);
        if (comparable == null) {
            return "";
        }
        Format format = (Format)this.getSetting(LABEL_FORMAT);
        if (format == null && row.isColumnNumeric(n)) {
            format = NumberFormat.getInstance();
        }
        if (format != null) {
            return format.format(comparable);
        }
        return comparable.toString();
    }

    @Override
    public void add(DataSource dataSource) {
        super.add(dataSource);
        dataSource.addDataListener(this);
    }

    @Override
    public void remove(DataSource dataSource) {
        super.remove(dataSource);
        dataSource.removeDataListener(this);
    }

    @Override
    public void settingChanged(SettingChangeEvent serializable) {
        super.settingChanged((SettingChangeEvent)serializable);
        serializable = serializable.getKey();
        if (LABEL_COLUMN.equals(serializable) || LABEL_FORMAT.equals(serializable)) {
            this.invalidate();
            this.refresh();
        }
    }

    @Override
    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.invalidate();
    }

    @Override
    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.invalidate();
    }

    @Override
    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.invalidate();
    }
}

