/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.legends;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.EdgeLayout;
import de.erichseifert.gral.graphics.StackedLayout;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.StylableContainer;
import de.erichseifert.gral.plots.legends.Legend;
import de.erichseifert.gral.plots.legends.LegendSymbolRenderer;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.plots.settings.SettingsStorage;
import de.erichseifert.gral.util.Dimension2D;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.Location;
import de.erichseifert.gral.util.Orientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLegend
extends StylableContainer
implements Legend,
LegendSymbolRenderer {
    private static final long serialVersionUID = -1561976879958765700L;
    private final Set<DataSource> a;
    private final Map<Row, Drawable> b;
    private transient boolean c;

    public AbstractLegend() {
        this.setInsets(new Insets2D.Double(10.0));
        this.a = new LinkedHashSet<DataSource>();
        this.b = new HashMap<Row, Drawable>();
        this.setSettingDefault(BACKGROUND, Color.WHITE);
        this.setSettingDefault(BORDER, new BasicStroke(1.0f));
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(ORIENTATION, Orientation.VERTICAL);
        this.setSettingDefault(ALIGNMENT_X, 0.0);
        this.setSettingDefault(ALIGNMENT_Y, 0.0);
        this.setSettingDefault(GAP, new Dimension2D.Double(2.0, 0.5));
        this.setSettingDefault(SYMBOL_SIZE, new Dimension2D.Double(2.0, 2.0));
    }

    @Override
    public void draw(DrawingContext drawingContext) {
        if (this.b.isEmpty()) {
            return;
        }
        this.drawBackground(drawingContext);
        this.drawBorder(drawingContext);
        this.drawComponents(drawingContext);
    }

    protected void drawBackground(DrawingContext drawingContext) {
        Paint paint = (Paint)this.getSetting(BACKGROUND);
        if (paint != null) {
            GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null);
        }
    }

    protected void drawBorder(DrawingContext drawingContext) {
        Stroke stroke = (Stroke)this.getSetting(BORDER);
        if (stroke != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null, stroke);
        }
    }

    protected abstract Iterable<Row> getEntries(DataSource var1);

    protected abstract String getLabel(Row var1);

    @Override
    public void add(DataSource object) {
        this.a.add((DataSource)object);
        for (Row row : this.getEntries((DataSource)object)) {
            Object object2 = this.getLabel(row);
            Font font = (Font)this.getSetting(FONT);
            object2 = new Item(row, this, (String)object2, font);
            this.add((Drawable)object2);
            this.b.put(row, (Drawable)object2);
        }
        this.invalidate();
    }

    @Override
    public boolean contains(DataSource dataSource) {
        return this.a.contains(dataSource);
    }

    @Override
    public void remove(DataSource dataSource) {
        this.a.remove(dataSource);
        for (Row row : new HashSet<Row>(this.b.keySet())) {
            Drawable drawable;
            if (row.getSource() != dataSource || (drawable = this.b.remove(row)) == null) continue;
            this.remove(drawable);
        }
        this.invalidate();
    }

    @Override
    public void clear() {
        for (DataSource dataSource : new HashSet<DataSource>(this.a)) {
            this.remove(dataSource);
        }
    }

    @Override
    public void refresh() {
        if (this.isValid()) {
            return;
        }
        Object object = new LinkedHashSet<DataSource>(this.a);
        this.clear();
        object = object.iterator();
        while (object.hasNext()) {
            DataSource dataSource = (DataSource)object.next();
            this.add(dataSource);
        }
        this.c = true;
    }

    @Override
    public void settingChanged(SettingChangeEvent serializable) {
        if (ORIENTATION.equals(serializable = serializable.getKey()) || GAP.equals(serializable)) {
            Orientation orientation = (Orientation)((Object)this.getSetting(ORIENTATION));
            Dimension2D dimension2D = (Dimension2D)this.getSetting(GAP);
            if (GAP.equals(serializable) && dimension2D != null) {
                double d = ((Font)this.getSetting(FONT)).getSize2D();
                dimension2D.setSize(dimension2D.getWidth() * d, dimension2D.getHeight() * d);
            }
            StackedLayout stackedLayout = new StackedLayout(orientation, dimension2D);
            this.setLayout(stackedLayout);
            return;
        }
        if (FONT.equals(serializable)) {
            for (Drawable drawable : this.b.values()) {
                if (!(drawable instanceof Item)) continue;
                Item item = (Item)drawable;
                Font font = (Font)this.getSetting(FONT);
                item.c.setSetting(Label.FONT, font);
            }
        }
    }

    @Override
    public void setBounds(double d, double d2, double d3, double d4) {
        Dimension2D dimension2D = this.getPreferredSize();
        double d5 = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        double d6 = ((Number)this.getSetting(ALIGNMENT_Y)).doubleValue();
        super.setBounds(d + d5 * (d3 - dimension2D.getWidth()), d2 + d6 * (d4 - dimension2D.getHeight()), dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected boolean isValid() {
        return this.c;
    }

    protected void invalidate() {
        this.c = false;
    }

    protected static class Item
    extends DrawableContainer {
        private static final long serialVersionUID = 3401141040936913098L;
        private final Row a;
        private final Drawable b;
        private final Label c;

        public Item(Row row, LegendSymbolRenderer legendSymbolRenderer, String string, Font font) {
            double d = font.getSize2D();
            this.setLayout(new EdgeLayout(d, 0.0));
            this.a = row;
            this.b = legendSymbolRenderer.getSymbol(row);
            this.add(this.b, (Object)Location.WEST);
            this.c = new Label(string);
            this.c.setSetting(Label.FONT, font);
            this.c.setSetting(Label.ALIGNMENT_X, 0.0);
            this.c.setSetting(Label.ALIGNMENT_Y, 0.5);
            this.add(this.c, (Object)Location.CENTER);
        }

        public Row getRow() {
            return this.a;
        }
    }

    protected static abstract class AbstractSymbol
    extends AbstractDrawable {
        private static final long serialVersionUID = 7475404103140652668L;
        private final SettingsStorage a;

        public AbstractSymbol(SettingsStorage settingsStorage) {
            this.a = settingsStorage;
        }

        public Dimension2D getPreferredSize() {
            double d = ((Font)this.a.getSetting(Legend.FONT)).getSize2D();
            Dimension2D dimension2D = (Dimension2D)this.a.getSetting(Legend.SYMBOL_SIZE);
            Dimension2D dimension2D2 = super.getPreferredSize();
            dimension2D2.setSize(dimension2D.getWidth() * d, dimension2D.getHeight() * d);
            return dimension2D2;
        }
    }
}

